/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.embedded;

import io.micronaut.core.io.ResourceLoader;
import io.micronaut.testresources.core.LazyTestResourcesPropertySourceLoader;
import io.micronaut.testresources.core.PropertyExpressionProducer;
import io.micronaut.testresources.core.TestResourcesResolver;
import io.micronaut.testresources.embedded.TestResourcesResolverLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class EmbeddedTestResourcesPropertySourceLoader
extends LazyTestResourcesPropertySourceLoader {
    private static final Pattern CAMEL_CASE = Pattern.compile("([a-z])([A-Z])");

    public EmbeddedTestResourcesPropertySourceLoader() {
        super((PropertyExpressionProducer)new EmbeddedTestResourcesProducer());
    }

    private static class EmbeddedTestResourcesProducer
    implements PropertyExpressionProducer {
        private final TestResourcesResolverLoader loader = TestResourcesResolverLoader.getInstance();

        private EmbeddedTestResourcesProducer() {
        }

        public List<String> getPropertyEntries() {
            return this.loader.getResolvers().stream().flatMap(resolver -> resolver.getRequiredPropertyEntries().stream()).distinct().collect(Collectors.toList());
        }

        public List<String> produceKeys(ResourceLoader resourceLoader, Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
            return this.loader.getResolvers().stream().flatMap(r -> r.getResolvableProperties(propertyEntries, testResourcesConfig).stream().map(key -> EmbeddedTestResourcesProducer.assertValidKey(key, r))).distinct().collect(Collectors.toList());
        }

        private static String assertValidKey(String key, TestResourcesResolver r) {
            Matcher m = CAMEL_CASE.matcher(key);
            if (m.find()) {
                throw new IllegalArgumentException("Test resources resolver [" + r.getClass().getName() + "] : Property key [" + key + "] is not valid. Property keys must be in kebab case.");
            }
            return key;
        }
    }
}

