/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.extensions.junit5;

import io.micronaut.test.extensions.junit5.ScopeHolder;
import io.micronaut.test.extensions.junit5.TestResourcesScopeListener;
import io.micronaut.test.extensions.junit5.annotation.ScopeNamingStrategy;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.SpecInfo;

public class SpockScopeExtension
implements IGlobalExtension {
    public void visitSpec(SpecInfo spec) {
        spec.addSharedInitializerInterceptor(invocation -> {
            SpockScopeExtension.maybeSetScope(invocation);
            invocation.proceed();
        });
    }

    private static void maybeSetScope(IMethodInvocation invocation) {
        Class<?> clazz = invocation.getInstance().getClass();
        TestResourcesScopeListener.findTestResourceScopeAnnotation(clazz).ifPresent(scopeAnn -> {
            Class<? extends ScopeNamingStrategy> namingStrategy;
            String scopeName = scopeAnn.value();
            if ((scopeName == null || scopeName.isEmpty()) && !(namingStrategy = scopeAnn.namingStrategy()).equals(ScopeNamingStrategy.class)) {
                ScopeNamingStrategy scopeNamingStrategy = TestResourcesScopeListener.instantitateStrategy(namingStrategy);
                scopeName = scopeNamingStrategy.scopeNameFor(clazz);
            }
            ScopeHolder.set(scopeName);
        });
    }
}

