/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.extensions.junit5;

import io.micronaut.test.extensions.junit5.ScopeHolder;
import io.micronaut.test.extensions.junit5.annotation.ScopeNamingStrategy;
import io.micronaut.test.extensions.junit5.annotation.TestResourcesScope;
import io.micronaut.test.extensions.testresources.TestResourcesClientHolder;
import io.micronaut.testresources.client.TestResourcesClient;
import io.micronaut.testresources.client.TestResourcesClientFactory;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class TestResourcesScopeListener
implements TestExecutionListener {
    private final Map<String, Set<String>> testsUsingResources = new ConcurrentHashMap<String, Set<String>>();
    private TestResourcesClient testResourcesClient;
    private final Deque<String> nestedScopes = new ArrayDeque<String>();

    private void assertTestResourcesClient() {
        if (this.testResourcesClient == null) {
            this.testResourcesClient = TestResourcesClientFactory.fromSystemProperties().orElse(TestResourcesClientHolder.lazy());
        }
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.assertTestResourcesClient();
        Set roots = testPlan.getRoots();
        this.visitTestIdentifiers(roots, testPlan);
    }

    public void executionStarted(TestIdentifier id) {
        this.assertTestResourcesClient();
        this.visitTestIdentifier(id, EventKind.TEST_STARTED);
    }

    public void executionFinished(TestIdentifier id, TestExecutionResult testExecutionResult) {
        this.assertTestResourcesClient();
        this.visitTestIdentifier(id, EventKind.TEST_FINISHED);
    }

    private void visitTestIdentifiers(Set<TestIdentifier> ids, TestPlan testPlan) {
        for (TestIdentifier id : ids) {
            this.visitTestIdentifier(id, EventKind.TEST_REGISTERED);
            this.visitTestIdentifiers(testPlan.getChildren(id), testPlan);
        }
    }

    private void visitTestIdentifier(TestIdentifier id, EventKind kind) {
        id.getSource().ifPresent(source -> {
            if (source instanceof ClassSource) {
                ClassSource classSource = (ClassSource)source;
                TestResourcesScopeListener.findTestResourceScopeAnnotation(classSource.getJavaClass()).ifPresent(testResourcesScope -> this.visitTestIdentifierWithAnnotation(id, kind, (TestResourcesScope)testResourcesScope));
            }
        });
    }

    private void visitTestIdentifierWithAnnotation(TestIdentifier id, EventKind kind, TestResourcesScope testResourcesScope) {
        TestSource testSource;
        if (id.getSource().isPresent() && (testSource = (TestSource)id.getSource().get()) instanceof ClassSource) {
            ClassSource classSource = (ClassSource)testSource;
            Class testClass = classSource.getJavaClass();
            if (testResourcesScope != null) {
                Optional<String> scope = TestResourcesScopeListener.findScope(testResourcesScope, testClass);
                scope.ifPresent(scopeName -> {
                    if (!scopeName.isEmpty()) {
                        this.visitRequiredScope(id, kind, (String)scopeName);
                    }
                });
            }
        }
    }

    private static Optional<String> findScope(TestResourcesScope testResourcesScope, Class<?> testClass) {
        Class<? extends ScopeNamingStrategy> namingStrategy;
        String scopeName = testResourcesScope.value();
        if ((scopeName == null || scopeName.isEmpty()) && !(namingStrategy = testResourcesScope.namingStrategy()).equals(ScopeNamingStrategy.class)) {
            ScopeNamingStrategy scopeNamingStrategy = TestResourcesScopeListener.instantitateStrategy(namingStrategy);
            scopeName = scopeNamingStrategy.scopeNameFor(testClass);
        }
        return Optional.ofNullable(scopeName);
    }

    private void visitRequiredScope(TestIdentifier id, EventKind kind, String scopeName) {
        Set testIdentifiers = this.testsUsingResources.computeIfAbsent(scopeName, scope -> new ConcurrentSkipListSet());
        String testId = id.getUniqueId();
        switch (kind) {
            case TEST_REGISTERED: {
                testIdentifiers.add(testId);
                break;
            }
            case TEST_STARTED: {
                ScopeHolder.get().ifPresent(this.nestedScopes::push);
                ScopeHolder.set(scopeName);
                System.out.println("testId = " + testId + " started with scope " + scopeName + " nested scopes = " + this.nestedScopes);
                break;
            }
            case TEST_FINISHED: {
                System.out.println("testId = " + testId + " finished with scope " + scopeName + " nested scopes = " + this.nestedScopes);
                if (testIdentifiers.remove(testId)) {
                    ScopeHolder.set(this.nestedScopes.poll());
                    if (ScopeHolder.get().isEmpty()) {
                        ScopeHolder.remove();
                    }
                    if (testIdentifiers.isEmpty()) {
                        this.testResourcesClient.closeScope(scopeName);
                    }
                }
                System.out.println("testId = " + testId + " finished and remaining nested scopes = " + this.nestedScopes);
            }
        }
    }

    public static Optional<TestResourcesScope> findTestResourceScopeAnnotation(Class<?> clazz) {
        return Optional.ofNullable(clazz.getAnnotation(TestResourcesScope.class)).or(() -> TestResourcesScopeListener.findTestResourceScopeAnnotationFromInterfaces(clazz));
    }

    private static Optional<TestResourcesScope> findTestResourceScopeAnnotationFromInterfaces(Class<?> clazz) {
        AnnotatedType[] annotatedInterfaces = clazz.getAnnotatedInterfaces();
        LinkedHashMap foundScopes = new LinkedHashMap();
        TestResourcesScopeListener.collectScopes(annotatedInterfaces, foundScopes);
        if (foundScopes.size() > 1) {
            Map.Entry first = (Map.Entry)foundScopes.entrySet().stream().findFirst().get();
            System.err.println("[WARNING] Multiple interfaces declare a test resources scope. Only one can be used, make sure to annotate your class instead. Using scope declared in " + first.getKey());
            return Optional.of((TestResourcesScope)first.getValue());
        }
        return foundScopes.values().stream().findFirst();
    }

    private static void collectScopes(AnnotatedType[] annotatedInterfaces, Map<Class<?>, TestResourcesScope> foundScopes) {
        for (AnnotatedType annotatedInterface : annotatedInterfaces) {
            Type type = annotatedInterface.getType();
            if (!(type instanceof Class)) continue;
            Class annotatedClass = (Class)type;
            TestResourcesScope annotation = annotatedClass.getAnnotation(TestResourcesScope.class);
            if (annotation != null) {
                foundScopes.put(annotatedClass, annotation);
                continue;
            }
            TestResourcesScopeListener.collectScopes(annotatedClass.getAnnotatedInterfaces(), foundScopes);
        }
    }

    static ScopeNamingStrategy instantitateStrategy(Class<? extends ScopeNamingStrategy> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Scope naming strategy must have a public constructor without arguments", e);
        }
    }

    private static enum EventKind {
        TEST_REGISTERED,
        TEST_STARTED,
        TEST_FINISHED;

    }
}

