/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.hivemq;

import io.micronaut.testresources.testcontainers.AbstractTestContainersProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.testcontainers.hivemq.HiveMQContainer;
import org.testcontainers.utility.DockerImageName;

public class HiveMQTestResourceProvider
extends AbstractTestContainersProvider<HiveMQContainer> {
    public static final String MQTT_CLIENT_CLIENT_ID = "mqtt.client.client-id";
    public static final String MQTT_CLIENT_SERVER_URI = "mqtt.client.server-uri";
    public static final String DEFAULT_IMAGE = "hivemq/hivemq-ce:2021.3";
    public static final String DISPLAY_NAME = "HiveMQ";
    private final String clientId = UUID.randomUUID().toString();

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        return List.of(MQTT_CLIENT_CLIENT_ID, MQTT_CLIENT_SERVER_URI);
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    protected String getSimpleName() {
        return "hivemq";
    }

    protected String getDefaultImageName() {
        return DEFAULT_IMAGE;
    }

    protected HiveMQContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return new HiveMQContainer(imageName);
    }

    protected Optional<String> resolveProperty(String propertyName, HiveMQContainer container) {
        if (MQTT_CLIENT_CLIENT_ID.equals(propertyName)) {
            return Optional.of(this.clientId);
        }
        return Optional.of("tcp://" + container.getHost() + ":" + container.getMqttPort());
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return MQTT_CLIENT_SERVER_URI.equals(propertyName) || MQTT_CLIENT_CLIENT_ID.equals(propertyName);
    }
}

