/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.mssql;

import io.micronaut.testresources.jdbc.AbstractJdbcTestResourceProvider;
import java.util.Map;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.LicenseAcceptance;

public class MSSQLTestResourceProvider
extends AbstractJdbcTestResourceProvider<MSSQLServerContainer<?>> {
    public static final String DEFAULT_IMAGE_NAME = "mcr.microsoft.com/mssql/server:2019-CU16-GDR1-ubuntu-20.04";

    protected String getSimpleName() {
        return "mssql";
    }

    protected String getDefaultImageName() {
        return DEFAULT_IMAGE_NAME;
    }

    protected MSSQLServerContainer<?> createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return MSSQLTestResourceProvider.createMSSQLContainer(imageName, this.getSimpleName(), testResourcesConfig);
    }

    public static MSSQLServerContainer<?> createMSSQLContainer(DockerImageName imageName, String simpleName, Map<String, Object> testResourcesConfig) {
        MSSQLServerContainer container = new MSSQLServerContainer(imageName);
        String licenseKey = "containers." + simpleName + ".accept-license";
        if (MSSQLTestResourceProvider.shouldAcceptLicense(licenseKey, testResourcesConfig)) {
            container.acceptLicense();
        } else {
            try {
                LicenseAcceptance.assertLicenseAccepted((String)imageName.toString());
            }
            catch (IllegalStateException ex) {
                throw new IllegalStateException("You must set the property 'test-resources." + licenseKey + "' to true in order to use a Microsoft SQL Server test container", ex);
            }
        }
        return container;
    }

    public static boolean shouldAcceptLicense(String licenseKey, Map<String, Object> testResourcesConfig) {
        Object obj = testResourcesConfig.get(licenseKey);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            Boolean b = (Boolean)obj;
            return b;
        }
        return Boolean.parseBoolean(obj.toString());
    }
}

