/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.mysql;

import io.micronaut.testresources.jdbc.AbstractJdbcTestResourceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.utility.DockerImageName;

public class MySQLTestResourceProvider
extends AbstractJdbcTestResourceProvider<MySQLContainer<?>> {
    public static final String DISPLAY_NAME = "MySQL";
    public static final String MYSQL_OFFICIAL_IMAGE = "container-registry.oracle.com/mysql/community-server";
    public static final String DOCKER_OFFICIAL_IMAGE = "mysql";
    public static final String SIMPLE_NAME = "mysql";
    public static final String X_PROTOCOL_URL = "x-protocol-url";
    public static final int DEFAULT_X_PROTOCOL_PORT = 33060;

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    protected String getSimpleName() {
        return "mysql";
    }

    protected String getDefaultImageName() {
        return MYSQL_OFFICIAL_IMAGE;
    }

    protected MySQLContainer<?> createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        if (imageName.asCanonicalNameString().startsWith(MYSQL_OFFICIAL_IMAGE)) {
            imageName = imageName.asCompatibleSubstituteFor("mysql");
        }
        return new MySQLContainer(imageName);
    }

    protected void configureContainer(MySQLContainer<?> container, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        container.withExposedPorts(new Integer[]{MySQLContainer.MYSQL_PORT, 33060});
    }

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        ArrayList<String> resolvableProperties = new ArrayList<String>(super.getResolvableProperties(propertyEntries, testResourcesConfig));
        Collection datasources = propertyEntries.getOrDefault("datasources", Collections.emptyList());
        List<String> properties = datasources.stream().map(ds -> "datasources." + ds + ".x-protocol-url").toList();
        resolvableProperties.addAll(properties);
        return resolvableProperties;
    }

    protected String resolveDbSpecificProperty(String propertyName, JdbcDatabaseContainer<?> container) {
        if (X_PROTOCOL_URL.equals(propertyName.substring(propertyName.lastIndexOf(".") + 1))) {
            String username = container.getUsername();
            String password = container.getPassword();
            String host = container.getHost();
            String port = String.valueOf(container.getMappedPort(33060));
            String schema = container.getDatabaseName();
            return "mysqlx://%s:%s@%s:%s/%s".formatted(username, password, host, port, schema);
        }
        return super.resolveDbSpecificProperty(propertyName, container);
    }
}

