/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.oracle.free;

import io.micronaut.testresources.jdbc.AbstractJdbcTestResourceProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.testcontainers.oracle.OracleContainer;
import org.testcontainers.utility.DockerImageName;

public class OracleFreeTestResourceProvider
extends AbstractJdbcTestResourceProvider<OracleContainer> {
    public static final String DISPLAY_NAME = "Oracle Database";
    private static final String OCID = "ocid";

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public List<String> getRequiredProperties(String expression) {
        if (!OracleFreeTestResourceProvider.isDatasourceExpression((String)expression)) {
            return Collections.emptyList();
        }
        List requiredProperties = super.getRequiredProperties(expression);
        String datasource = OracleFreeTestResourceProvider.datasourceNameFrom((String)expression);
        return Stream.concat(requiredProperties.stream(), Stream.of(OracleFreeTestResourceProvider.datasourceExpressionOf((String)datasource, (String)OCID))).toList();
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        String datasource;
        String ocid;
        boolean shouldAnswer = super.shouldAnswer(propertyName, requestedProperties, testResourcesConfig);
        if (shouldAnswer && (ocid = this.stringOrNull(requestedProperties.get(OracleFreeTestResourceProvider.datasourceExpressionOf((String)(datasource = OracleFreeTestResourceProvider.datasourceNameFrom((String)propertyName)), (String)OCID)))) != null) {
            return false;
        }
        return shouldAnswer;
    }

    protected String getSimpleName() {
        return "oracle";
    }

    protected String getDefaultImageName() {
        return "gvenzl/oracle-free:slim-faststart";
    }

    protected OracleContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return new OracleContainer(imageName);
    }
}

