/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.oracle.xe;

import io.micronaut.testresources.jdbc.AbstractJdbcTestResourceProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.utility.DockerImageName;

public class OracleXETestResourceProvider
extends AbstractJdbcTestResourceProvider<OracleContainer> {
    private static final String OCID = "ocid";

    public List<String> getRequiredProperties(String expression) {
        if (!OracleXETestResourceProvider.isDatasourceExpression((String)expression)) {
            return Collections.emptyList();
        }
        List requiredProperties = super.getRequiredProperties(expression);
        String datasource = OracleXETestResourceProvider.datasourceNameFrom((String)expression);
        return Stream.concat(requiredProperties.stream(), Stream.of(OracleXETestResourceProvider.datasourceExpressionOf((String)datasource, (String)OCID))).collect(Collectors.toList());
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        String datasource;
        String ocid;
        boolean shouldAnswer = super.shouldAnswer(propertyName, requestedProperties, testResourcesConfig);
        if (shouldAnswer && (ocid = this.stringOrNull(requestedProperties.get(OracleXETestResourceProvider.datasourceExpressionOf((String)(datasource = OracleXETestResourceProvider.datasourceNameFrom((String)propertyName)), (String)OCID)))) != null) {
            return false;
        }
        return shouldAnswer;
    }

    protected String getSimpleName() {
        return "oracle";
    }

    protected String getDefaultImageName() {
        return "gvenzl/oracle-xe:slim-faststart";
    }

    protected OracleContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return new OracleContainer(imageName);
    }
}

