/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.kafka;

import io.micronaut.testresources.testcontainers.AbstractTestContainersProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.utility.DockerImageName;

public class KafkaTestResourceProvider
extends AbstractTestContainersProvider<KafkaContainer> {
    public static final String KAFKA_BOOTSTRAP_SERVERS = "kafka.bootstrap.servers";
    public static final String DEFAULT_IMAGE = "confluentinc/cp-kafka:7.0.4";

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        return Collections.singletonList(KAFKA_BOOTSTRAP_SERVERS);
    }

    protected String getSimpleName() {
        return "kafka";
    }

    protected String getDefaultImageName() {
        return DEFAULT_IMAGE;
    }

    protected KafkaContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return new KafkaContainer(imageName);
    }

    protected Optional<String> resolveProperty(String propertyName, KafkaContainer container) {
        return Optional.of(container.getBootstrapServers());
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return KAFKA_BOOTSTRAP_SERVERS.equals(propertyName);
    }
}

