/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.localstack.s3;

import io.micronaut.testresources.localstack.LocalStackService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.testcontainers.containers.localstack.LocalStackContainer;

public class LocalStackS3Service
implements LocalStackService {
    private static final String AWS_S3_ENDPOINT_OVERRIDE = "aws.services.s3.endpoint-override";

    public Optional<String> resolveProperty(String propertyName, LocalStackContainer container) {
        if (AWS_S3_ENDPOINT_OVERRIDE.equals(propertyName)) {
            return Optional.of(container.getEndpointOverride(LocalStackContainer.Service.S3).toString());
        }
        return Optional.empty();
    }

    public LocalStackContainer.Service getServiceKind() {
        return LocalStackContainer.Service.S3;
    }

    public List<String> getResolvableProperties() {
        return Collections.singletonList(AWS_S3_ENDPOINT_OVERRIDE);
    }
}

