/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.localstack.sqs;

import io.micronaut.testresources.localstack.LocalStackService;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.testcontainers.containers.localstack.LocalStackContainer;

public class LocalStackSQSService
implements LocalStackService {
    private static final String AWS_SQS_ENDPOINT_OVERRIDE = "aws.services.sqs.endpoint-override";

    public Optional<String> resolveProperty(String propertyName, LocalStackContainer container) {
        if (AWS_SQS_ENDPOINT_OVERRIDE.equals(propertyName)) {
            return Optional.of(container.getEndpointOverride(LocalStackContainer.Service.SQS).toString());
        }
        return Optional.empty();
    }

    public LocalStackContainer.Service getServiceKind() {
        return LocalStackContainer.Service.SQS;
    }

    public List<String> getResolvableProperties() {
        return Collections.singletonList(AWS_SQS_ENDPOINT_OVERRIDE);
    }
}

