/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.neo4j;

import io.micronaut.testresources.testcontainers.AbstractTestContainersProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.containers.Neo4jContainer;
import org.testcontainers.utility.DockerImageName;

public class Neo4jTestResourceProvider
extends AbstractTestContainersProvider<Neo4jContainer<?>> {
    public static final String NEO4J_SERVER_URI = "neo4j.uri";
    public static final String DEFAULT_IMAGE = "neo4j";
    private static final Set<String> SUPPORTED_PROPERTIES;
    public static final String DISPLAY_NAME = "Neo4J";

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        return Collections.singletonList(NEO4J_SERVER_URI);
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    protected String getSimpleName() {
        return DEFAULT_IMAGE;
    }

    protected String getDefaultImageName() {
        return DEFAULT_IMAGE;
    }

    protected Neo4jContainer<?> createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        Neo4jContainer container = new Neo4jContainer(imageName);
        container.withoutAuthentication();
        return container;
    }

    protected Optional<String> resolveProperty(String propertyName, Neo4jContainer<?> container) {
        if (NEO4J_SERVER_URI.equals(propertyName)) {
            return Optional.of(container.getBoltUrl());
        }
        return Optional.empty();
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return SUPPORTED_PROPERTIES.contains(propertyName);
    }

    static {
        HashSet<String> supported = new HashSet<String>();
        supported.add(NEO4J_SERVER_URI);
        SUPPORTED_PROPERTIES = Collections.unmodifiableSet(supported);
    }
}

