/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.r2dbc.oracle;

import io.micronaut.testresources.r2dbc.core.AbstractR2DBCTestResourceProvider;
import io.micronaut.testresources.r2dbc.core.R2dbcSupport;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.oracle.OracleContainer;
import org.testcontainers.utility.DockerImageName;

public class R2DBCOracleFreeTestResourceProvider
extends AbstractR2DBCTestResourceProvider<OracleContainer> {
    public static final String DISPLAY_NAME = "Oracle Database (R2DBC)";
    private static final String R2DBC_ORACLE_DRIVER = "oracle";
    private static final String OCID = "ocid";

    public List<String> getRequiredProperties(String expression) {
        List requiredProperties = super.getRequiredProperties(expression);
        String baseDatasourceExpression = R2dbcSupport.removeR2dbPrefixFrom((String)expression);
        String datasource = R2dbcSupport.datasourceNameFrom((String)baseDatasourceExpression);
        return Stream.concat(requiredProperties.stream(), Stream.of(R2dbcSupport.r2dbDatasourceExpressionOf((String)datasource, (String)OCID))).toList();
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        String baseDatasourceExpression;
        String datasource;
        String ocid;
        boolean shouldAnswer = super.shouldAnswer(propertyName, requestedProperties, testResourcesConfig);
        if (shouldAnswer && (ocid = this.stringOrNull(requestedProperties.get(R2dbcSupport.r2dbDatasourceExpressionOf((String)(datasource = R2dbcSupport.datasourceNameFrom((String)(baseDatasourceExpression = R2dbcSupport.removeR2dbPrefixFrom((String)propertyName)))), (String)OCID)))) != null) {
            return false;
        }
        return shouldAnswer;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    protected String getSimpleName() {
        return R2DBC_ORACLE_DRIVER;
    }

    protected String getDefaultImageName() {
        return "gvenzl/oracle-free:slim-faststart";
    }

    protected Optional<ConnectionFactoryOptions> extractOptions(GenericContainer<?> container) {
        if (container instanceof OracleContainer) {
            OracleContainer oracle = (OracleContainer)container;
            ConnectionFactoryOptions options = ConnectionFactoryOptions.builder().option(ConnectionFactoryOptions.USER, (Object)oracle.getUsername()).option(ConnectionFactoryOptions.PASSWORD, (Object)oracle.getPassword()).option(ConnectionFactoryOptions.HOST, (Object)oracle.getHost()).option(ConnectionFactoryOptions.PORT, (Object)oracle.getOraclePort()).option(ConnectionFactoryOptions.DATABASE, (Object)oracle.getDatabaseName()).option(ConnectionFactoryOptions.DRIVER, (Object)R2DBC_ORACLE_DRIVER).build();
            return Optional.of(options);
        }
        return Optional.empty();
    }

    protected OracleContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return new OracleContainer(imageName);
    }
}

