/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.r2dbc.pool;

import io.micronaut.testresources.core.ToggableTestResourcesResolver;
import io.micronaut.testresources.r2dbc.core.R2dbcSupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class R2DBCPoolTestResourceProvider
implements ToggableTestResourcesResolver {
    private static final String PROTOCOL = "options.protocol";
    private static final String DRIVER = "options.driver";
    private static final List<String> RESOLVABLE_KEYS = Collections.unmodifiableList(Arrays.asList("options.protocol", "options.driver"));
    public static final String DISPLAY_NAME = "R2DBC Pool";

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getName() {
        return "r2dbc-pool";
    }

    public List<String> getRequiredPropertyEntries() {
        return R2dbcSupport.REQUIRED_PROPERTY_ENTRIES_LIST;
    }

    public List<String> getRequiredProperties(String expression) {
        return R2dbcSupport.findRequiredProperties((String)expression);
    }

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        return R2dbcSupport.findResolvableProperties(propertyEntries, RESOLVABLE_KEYS);
    }

    public Optional<String> resolve(String propertyName, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        if (!propertyName.startsWith("r2dbc.")) {
            return Optional.empty();
        }
        String baseDatasourceExpression = R2dbcSupport.removeR2dbPrefixFrom((String)propertyName);
        String datasource = R2dbcSupport.datasourceNameFrom((String)baseDatasourceExpression);
        if (R2dbcSupport.r2dbDatasourceExpressionOf((String)datasource, (String)PROTOCOL).equals(propertyName)) {
            Object dialect = properties.get(R2dbcSupport.r2dbDatasourceExpressionOf((String)datasource, (String)"dialect"));
            if (dialect != null) {
                return Optional.of(String.valueOf(dialect).replace("_", "").toLowerCase(Locale.ROOT));
            }
        } else if (R2dbcSupport.r2dbDatasourceExpressionOf((String)datasource, (String)DRIVER).equals(propertyName)) {
            return Optional.of("pool");
        }
        return Optional.empty();
    }
}

