/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.r2dbc.postgres;

import io.micronaut.testresources.r2dbc.core.AbstractR2DBCTestResourceProvider;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.PostgreSQLR2DBCDatabaseContainer;
import org.testcontainers.utility.DockerImageName;

public class R2DBCPostgreSQLTestResourceProvider
extends AbstractR2DBCTestResourceProvider<PostgreSQLContainer<?>> {
    private static final List<String> SUPPORTED_DB_TYPES = Collections.unmodifiableList(Arrays.asList("postgresql", "postgres", "pg"));
    public static final String DISPLAY_NAME = "PostgreSQL (R2DBC)";

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    protected String getSimpleName() {
        return "postgres";
    }

    protected String getDefaultImageName() {
        return "postgres";
    }

    protected List<String> getDbTypes() {
        return SUPPORTED_DB_TYPES;
    }

    protected Optional<ConnectionFactoryOptions> extractOptions(GenericContainer<?> container) {
        if (container instanceof PostgreSQLContainer) {
            return Optional.of(PostgreSQLR2DBCDatabaseContainer.getOptions((PostgreSQLContainer)((PostgreSQLContainer)container)));
        }
        return Optional.empty();
    }

    protected PostgreSQLContainer<?> createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return new PostgreSQLContainer(imageName);
    }
}

