/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.rabbitmq;

import io.micronaut.testresources.testcontainers.AbstractTestContainersProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.containers.RabbitMQContainer;
import org.testcontainers.utility.DockerImageName;

public class RabbitMQTestResourceProvider
extends AbstractTestContainersProvider<RabbitMQContainer> {
    public static final String RABBITMQ_URI = "rabbitmq.uri";
    public static final String RABBITMQ_USERNAME = "rabbitmq.username";
    public static final String RABBITMQ_PASSWORD = "rabbitmq.password";
    public static final String DEFAULT_IMAGE = "rabbitmq";
    public static final List<String> SUPPORTED_KEYS = Collections.unmodifiableList(Arrays.asList("rabbitmq.uri", "rabbitmq.username", "rabbitmq.password"));
    private static final Set<String> SUPPORTED_KEYSET = Collections.unmodifiableSet(new HashSet<String>(SUPPORTED_KEYS));
    public static final String DISPLAY_NAME = "RabbitMQ";

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        return SUPPORTED_KEYS;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    protected String getSimpleName() {
        return DEFAULT_IMAGE;
    }

    protected String getDefaultImageName() {
        return DEFAULT_IMAGE;
    }

    protected RabbitMQContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return new RabbitMQContainer(imageName);
    }

    protected Optional<String> resolveProperty(String propertyName, RabbitMQContainer container) {
        switch (propertyName) {
            case "rabbitmq.uri": {
                return Optional.of(container.getAmqpUrl());
            }
            case "rabbitmq.username": {
                return Optional.of(container.getAdminUsername());
            }
            case "rabbitmq.password": {
                return Optional.of(container.getAdminPassword());
            }
        }
        return Optional.empty();
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return SUPPORTED_KEYSET.contains(propertyName);
    }
}

