/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.redis;

import com.redis.testcontainers.RedisClusterContainer;
import io.micronaut.testresources.redis.RedisConfigurationSupport;
import io.micronaut.testresources.testcontainers.AbstractTestContainersProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class RedisClusterTestResourceProvider
extends AbstractTestContainersProvider<RedisClusterContainer> {
    public static final String REDIS_URIS = "redis.uris";
    public static final String DISPLAY_NAME = "Redis";
    public static final String SIMPLE_NAME = "redis";
    public static final String DEFAULT_IMAGE = RedisClusterContainer.DEFAULT_IMAGE_NAME.asCanonicalNameString();
    private static final List<String> SUPPORTED_PROPERTIES_LIST = List.of("redis.uris");
    private static final Set<String> SUPPORTED_PROPERTIES = Set.of("redis.uris");
    private static final String NOTIFY_KEYSPACE_EVENTS_CONFIG_FORMAT = "notify-keyspace-events %s\n";
    private static final String CLUSTER_CONFIG = "bind ${BIND_ADDRESS}\nport ${PORT}\ncluster-enabled yes\ncluster-config-file nodes.conf\ncluster-node-timeout 5000\nappendonly yes\ndir /redis-data/${PORT}\nprotected-mode no\n";

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        boolean clusterMode = RedisConfigurationSupport.isClusterMode(testResourcesConfig);
        return clusterMode ? SUPPORTED_PROPERTIES_LIST : List.of();
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    protected String getSimpleName() {
        return SIMPLE_NAME;
    }

    protected String getDefaultImageName() {
        return DEFAULT_IMAGE;
    }

    protected RedisClusterContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        RedisClusterContainer redisClusterContainer = new RedisClusterContainer(imageName);
        redisClusterContainer.withMasters(RedisConfigurationSupport.findMasterCount(testResourcesConfig));
        redisClusterContainer.withSlavesPerMaster(RedisConfigurationSupport.findSlavesPerMasterCount(testResourcesConfig));
        redisClusterContainer.withInitialPort(RedisConfigurationSupport.findInitialPort(testResourcesConfig));
        redisClusterContainer.withIP(RedisConfigurationSupport.findIp(testResourcesConfig));
        String clusterConfig = CLUSTER_CONFIG + RedisConfigurationSupport.findNotifyKeyspaceEvents(testResourcesConfig).map(arg_0 -> RedisClusterTestResourceProvider.lambda$createContainer$0(NOTIFY_KEYSPACE_EVENTS_CONFIG_FORMAT, arg_0)).orElse("");
        redisClusterContainer.withCopyToContainer(Transferable.of((String)clusterConfig), "/redis-conf/redis-cluster.tmpl");
        return redisClusterContainer;
    }

    protected Optional<String> resolveProperty(String propertyName, RedisClusterContainer container) {
        if (REDIS_URIS.equals(propertyName)) {
            return Optional.of(String.join((CharSequence)",", container.getRedisURIs()));
        }
        return Optional.empty();
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return SUPPORTED_PROPERTIES.contains(propertyName);
    }

    private static /* synthetic */ String lambda$createContainer$0(String rec$, Object xva$0) {
        return NOTIFY_KEYSPACE_EVENTS_CONFIG_FORMAT.formatted(xva$0);
    }
}

