/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.redis;

import java.util.Map;
import java.util.Optional;

abstract class RedisConfigurationSupport {
    public static final String CONFIG_REDIS_CLUSTER_MODE = "containers.redis.cluster-mode";
    public static final String CONFIG_REDIS_CLUSTER_MASTERS = "containers.redis.cluster.masters";
    public static final String CONFIG_REDIS_CLUSTER_SLAVES = "containers.redis.cluster.slaves-per-master";
    public static final String CONFIG_REDIS_CLUSTER_INITIAL_PORT = "containers.redis.cluster.initial-port";
    public static final String CONFIG_REDIS_CLUSTER_IP = "containers.redis.cluster.ip";
    public static final String CONFIG_REDIS_CLUSTER_NOTIFY_KEYSPACE_EVENTS = "containers.redis.cluster.notify-keyspace-events";

    private RedisConfigurationSupport() {
    }

    static boolean isClusterMode(Map<String, Object> testResourcesConfig) {
        Boolean clusterMode = (Boolean)testResourcesConfig.getOrDefault(CONFIG_REDIS_CLUSTER_MODE, false);
        return Boolean.TRUE.equals(clusterMode);
    }

    static int findMasterCount(Map<String, Object> testResourcesConfig) {
        return (Integer)testResourcesConfig.getOrDefault(CONFIG_REDIS_CLUSTER_MASTERS, 3);
    }

    static int findSlavesPerMasterCount(Map<String, Object> testResourcesConfig) {
        return (Integer)testResourcesConfig.getOrDefault(CONFIG_REDIS_CLUSTER_SLAVES, 0);
    }

    static int findInitialPort(Map<String, Object> testResourcesConfig) {
        return (Integer)testResourcesConfig.getOrDefault(CONFIG_REDIS_CLUSTER_INITIAL_PORT, 7000);
    }

    static String findIp(Map<String, Object> testResourcesConfig) {
        return (String)testResourcesConfig.getOrDefault(CONFIG_REDIS_CLUSTER_IP, "0.0.0.0");
    }

    static Optional<String> findNotifyKeyspaceEvents(Map<String, Object> testResourcesConfig) {
        String notifyKeyspaceEvents = testResourcesConfig.getOrDefault(CONFIG_REDIS_CLUSTER_NOTIFY_KEYSPACE_EVENTS, null);
        return Optional.ofNullable(notifyKeyspaceEvents);
    }
}

