/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.redis;

import com.redis.testcontainers.RedisContainer;
import io.micronaut.testresources.redis.RedisConfigurationSupport;
import io.micronaut.testresources.testcontainers.AbstractTestContainersProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.utility.DockerImageName;

public class RedisTestResourceProvider
extends AbstractTestContainersProvider<RedisContainer> {
    public static final String REDIS_URI = "redis.uri";
    public static final String DEFAULT_IMAGE = RedisContainer.DEFAULT_IMAGE_NAME.asCanonicalNameString();
    public static final String SIMPLE_NAME = "redis";
    private static final List<String> SUPPORTED_PROPERTIES_LIST = List.of("redis.uri");
    private static final Set<String> SUPPORTED_PROPERTIES = Set.of("redis.uri");
    public static final String DISPLAY_NAME = "Redis";

    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        boolean clusterMode = RedisConfigurationSupport.isClusterMode(testResourcesConfig);
        return clusterMode ? List.of() : SUPPORTED_PROPERTIES_LIST;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    protected String getSimpleName() {
        return SIMPLE_NAME;
    }

    protected String getDefaultImageName() {
        return DEFAULT_IMAGE;
    }

    protected RedisContainer createContainer(DockerImageName imageName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return new RedisContainer(imageName);
    }

    protected Optional<String> resolveProperty(String propertyName, RedisContainer container) {
        if (REDIS_URI.equals(propertyName)) {
            return Optional.of(container.getRedisURI());
        }
        return Optional.empty();
    }

    protected boolean shouldAnswer(String propertyName, Map<String, Object> requestedProperties, Map<String, Object> testResourcesConfig) {
        return SUPPORTED_PROPERTIES.contains(propertyName);
    }
}

