/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.server;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.ApplicationContextConfigurer;
import io.micronaut.context.annotation.ContextConfigurer;
import io.micronaut.runtime.Micronaut;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Singleton;
import java.io.FileWriter;
import java.time.Duration;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        long sd = System.nanoTime();
        ApplicationContext context = Micronaut.run(Application.class, (String[])args);
        Arrays.stream(args).filter(arg -> arg.startsWith("--port-file=")).findFirst().map(arg -> arg.substring("--port-file=".length())).ifPresent(portFile -> {
            try (FileWriter writer = new FileWriter((String)portFile);){
                EmbeddedServer server = (EmbeddedServer)context.getBean(EmbeddedServer.class);
                int port = server.getPort();
                writer.write(String.valueOf(port));
                LOGGER.debug("Wrote port {} to {}", (Object)port, portFile);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        long dur = System.nanoTime() - sd;
        LOGGER.info("A Micronaut Test Resources server is listening on port {}, started in {}ms", (Object)((EmbeddedServer)context.getBean(EmbeddedServer.class)).getPort(), (Object)Duration.ofNanos(dur).toMillis());
    }

    @ContextConfigurer
    public static class Configurer
    implements ApplicationContextConfigurer {
        public void configure(ApplicationContextBuilder builder) {
            builder.packages(new String[]{"io.micronaut.testresources.server"}).deduceEnvironment(Boolean.valueOf(false)).banner(false);
        }
    }
}

