/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.server;

import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.testresources.core.Scope;
import io.micronaut.testresources.core.TestResourcesResolver;
import io.micronaut.testresources.embedded.TestResourcesResolverLoader;
import io.micronaut.testresources.server.TestContainer;
import io.micronaut.testresources.testcontainers.TestContainers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller(value="/")
public final class TestResourcesController
implements TestResourcesResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestResourcesController.class);
    private final TestResourcesResolverLoader loader = new TestResourcesResolverLoader();

    @Get(value="/list")
    public List<String> getResolvableProperties() {
        return this.getResolvableProperties(Collections.emptyMap(), Collections.emptyMap());
    }

    @Post(value="/list")
    public List<String> getResolvableProperties(Map<String, Collection<String>> propertyEntries, Map<String, Object> testResourcesConfig) {
        return this.loader.getResolvers().stream().map(r -> r.getResolvableProperties(propertyEntries, testResourcesConfig)).flatMap(Collection::stream).distinct().peek(p -> LOGGER.debug("For configuration {} and property entries {} , resolvable property: {}", new Object[]{testResourcesConfig, propertyEntries, p})).collect(Collectors.toList());
    }

    @Get(value="/requirements/expr/{expression}")
    public List<String> getRequiredProperties(String expression) {
        return this.loader.getResolvers().stream().map(testResourcesResolver -> testResourcesResolver.getRequiredProperties(expression)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Get(value="/requirements/entries")
    public List<String> getRequiredPropertyEntries() {
        return this.loader.getResolvers().stream().map(TestResourcesResolver::getRequiredPropertyEntries).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Post(value="/resolve")
    public Optional<String> resolve(String name, Map<String, Object> properties, Map<String, Object> testResourcesConfig) {
        Optional result = Optional.empty();
        for (TestResourcesResolver resolver : this.loader.getResolvers()) {
            result = resolver.resolve(name, properties, testResourcesConfig);
            LOGGER.debug("Attempt to resolve {} with resolver {}, properties {} and test resources configuration {} : {}", new Object[]{name, resolver.getClass(), properties, testResourcesConfig, result.isPresent() ? result.get() : "\ud83d\udeab"});
            if (!result.isPresent()) continue;
            return result;
        }
        return result;
    }

    @Get(value="/close/all")
    public void closeAll() {
        TestContainers.closeAll();
    }

    @Get(value="/close/{id}")
    public void closeScope(String id) {
        TestContainers.closeScope((String)id);
    }

    @Get(value="/testcontainers")
    public List<TestContainer> listContainers() {
        return this.listContainersByScope(null);
    }

    @Get(value="/testcontainers/{scope}")
    public List<TestContainer> listContainersByScope(String scope) {
        return TestContainers.listByScope((String)scope).entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(c -> new TestContainer(c.getContainerName(), c.getDockerImageName(), c.getContainerId(), ((Scope)entry.getKey()).toString()))).collect(Collectors.toList());
    }
}

