/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.propagation.slf4j;

import io.micronaut.core.propagation.ThreadPropagatedContextElement;
import java.util.Map;
import org.slf4j.MDC;

public record MdcPropagationContext(Map<String, String> state) implements ThreadPropagatedContextElement<Map<String, String>>
{
    public MdcPropagationContext() {
        this(MDC.getCopyOfContextMap());
    }

    @Override
    public Map<String, String> updateThreadContext() {
        Map<String, String> oldState = MDC.getCopyOfContextMap();
        this.setCurrent(this.state);
        return oldState;
    }

    @Override
    public void restoreThreadContext(Map<String, String> oldState) {
        this.setCurrent(oldState);
    }

    private void setCurrent(Map<String, String> contextMap) {
        if (contextMap == null) {
            MDC.clear();
        } else {
            MDC.setContextMap(contextMap);
        }
    }
}

