/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.server.netty.body.HttpBody;

@Internal
abstract class ManagedBody<T>
implements HttpBody {
    private final T value;
    private boolean claimed;
    private HttpBody next;

    ManagedBody(T value) {
        this.value = value;
    }

    final T value() {
        return this.value;
    }

    final T claim() {
        this.checkUnclaimed();
        this.claimed = true;
        return this.value;
    }

    final T prepareClaim() {
        this.checkUnclaimed();
        return this.value;
    }

    final void checkUnclaimed() {
        if (this.claimed) {
            throw new IllegalStateException("Already claimed");
        }
    }

    final <B extends HttpBody> B next(B next) {
        if (this.claimed) {
            throw new AssertionError((Object)"Should have called prepareClaim");
        }
        this.next = next;
        this.claim();
        return next;
    }

    @Override
    public final void release() {
        if (!this.claimed) {
            this.release(this.value);
        } else if (this.next != null) {
            this.next.release();
        }
    }

    abstract void release(T var1);

    @Override
    @Nullable
    public HttpBody next() {
        return this.next;
    }
}

