/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.provider;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Any;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Indexes;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.Named;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.InstantiatableBeanDefinition;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.qualifiers.AnyQualifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractProviderDefinition<T>
implements InstantiatableBeanDefinition<T>,
BeanDefinitionReference<T> {
    private static final Argument<Object> TYPE_VARIABLE = Argument.ofTypeVariable(Object.class, "T");
    private final AnnotationMetadata annotationMetadata;

    public AbstractProviderDefinition() {
        MutableAnnotationMetadata metadata = new MutableAnnotationMetadata();
        metadata.addDeclaredAnnotation(Any.class.getName(), Collections.emptyMap());
        metadata.addDeclaredStereotype(Collections.singletonList(Any.class.getName()), "jakarta.inject.Qualifier", Collections.emptyMap());
        metadata.addDeclaredAnnotation(BootstrapContextCompatible.class.getName(), Collections.emptyMap());
        try {
            metadata.addDeclaredAnnotation(Indexes.class.getName(), Collections.singletonMap("value", this.getBeanType()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.annotationMetadata = metadata;
    }

    @Override
    public boolean isContainerType() {
        return false;
    }

    @Override
    public boolean isCandidateBean(Argument<?> beanType) {
        return beanType.isAssignableFrom(this.getBeanType());
    }

    @Override
    public boolean isEnabled(@NonNull BeanContext context, @Nullable BeanResolutionContext resolutionContext) {
        return this.isPresent();
    }

    @Override
    public String getBeanDefinitionName() {
        return this.getClass().getName();
    }

    @Override
    public BeanDefinition<T> load() {
        return this;
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @NonNull
    protected abstract T buildProvider(@NonNull BeanResolutionContext var1, @NonNull BeanContext var2, @NonNull Argument<Object> var3, @Nullable Qualifier<Object> var4, boolean var5);

    @Override
    public T instantiate(BeanResolutionContext resolutionContext, BeanContext context) throws BeanInstantiationException {
        InjectionPoint injectionPoint;
        BeanResolutionContext.Segment segment = resolutionContext.getPath().currentSegment().orElse(null);
        if (segment != null && (injectionPoint = segment.getInjectionPoint()) instanceof ArgumentCoercible) {
            Argument argument;
            Argument injectionPointArgument = ((ArgumentCoercible)((Object)injectionPoint)).asArgument();
            Argument<Object> resolveArgument = injectionPointArgument;
            if (resolveArgument.isOptional()) {
                resolveArgument = resolveArgument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            }
            if ((argument = (Argument)resolveArgument.getFirstTypeVariable().orElse(null)) != null) {
                boolean hasBean;
                Object n;
                Qualifier<Object> qualifier = resolutionContext.getCurrentQualifier();
                if (qualifier == null && segment.getDeclaringType().isIterable() && (n = resolutionContext.getAttribute(Named.class.getName())) != null) {
                    qualifier = Qualifiers.byName(n.toString());
                }
                if (hasBean = context.containsBean(argument, qualifier)) {
                    return this.buildProvider(resolutionContext, context, argument, qualifier, this.isSingleton());
                }
                if (injectionPointArgument.isOptional()) {
                    return (T)Optional.empty();
                }
                if (injectionPointArgument.isNullable()) {
                    throw new DisabledBeanException("Nullable bean doesn't exist");
                }
                if (qualifier instanceof AnyQualifier || this.isAllowEmptyProviders(context)) {
                    return this.buildProvider(resolutionContext, context, argument, qualifier, this.isSingleton());
                }
                throw new NoSuchBeanException(argument, qualifier);
            }
        }
        throw new UnsupportedOperationException("Cannot inject provider for Object type");
    }

    protected boolean isAllowEmptyProviders(BeanContext context) {
        return context.getContextConfiguration().isAllowEmptyProviders();
    }

    @Override
    public final boolean isAbstract() {
        return false;
    }

    @Override
    public final boolean isSingleton() {
        return false;
    }

    @Override
    public boolean isConfigurationProperties() {
        return false;
    }

    @Override
    @NonNull
    public final List<Argument<?>> getTypeArguments(Class<?> type) {
        if (type == this.getBeanType()) {
            return this.getTypeArguments();
        }
        return Collections.emptyList();
    }

    @Override
    @NonNull
    public final List<Argument<?>> getTypeArguments() {
        return Collections.singletonList(TYPE_VARIABLE);
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public Qualifier<T> getDeclaredQualifier() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

