/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.inject.BeanType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public final class InterceptorBindingQualifier<T>
implements Qualifier<T> {
    public static final String META_BINDING_VALUES = "$bindingValues";
    private static final String META_MEMBER_INTERCEPTOR_TYPE = "interceptorType";
    private final Map<String, List<AnnotationValue<?>>> supportedAnnotationNames;
    private final Set<Class<?>> supportedInterceptorTypes;

    InterceptorBindingQualifier(AnnotationMetadata annotationMetadata) {
        AnnotationValue av = annotationMetadata.findAnnotation("io.micronaut.inject.qualifiers.InterceptorBindingQualifier").orElse(null);
        List<Object> annotationValues = av == null ? Collections.emptyList() : av.getAnnotations("value");
        this.supportedAnnotationNames = InterceptorBindingQualifier.findSupportedAnnotations(annotationValues);
        HashSet<Class<?>> supportedInterceptorTypes = CollectionUtils.newHashSet(annotationValues.size());
        for (AnnotationValue annotationValue : annotationValues) {
            annotationValue.classValue(META_MEMBER_INTERCEPTOR_TYPE).ifPresent(supportedInterceptorTypes::add);
        }
        this.supportedInterceptorTypes = supportedInterceptorTypes;
    }

    InterceptorBindingQualifier(Collection<AnnotationValue<?>> bindingAnnotations) {
        this.supportedAnnotationNames = CollectionUtils.isNotEmpty(bindingAnnotations) ? InterceptorBindingQualifier.findSupportedAnnotations(bindingAnnotations) : Collections.emptyMap();
        this.supportedInterceptorTypes = Collections.emptySet();
    }

    private static Map<String, List<AnnotationValue<?>>> findSupportedAnnotations(Collection<AnnotationValue<?>> annotationValues) {
        HashMap<String, List<AnnotationValue<?>>> supportedAnnotationNames = CollectionUtils.newHashMap(annotationValues.size());
        for (AnnotationValue<?> annotationValue : annotationValues) {
            String name = annotationValue.stringValue().orElse(null);
            if (name == null) continue;
            AnnotationValue members = annotationValue.getAnnotation(META_BINDING_VALUES).orElse(null);
            if (members != null) {
                List existing = supportedAnnotationNames.computeIfAbsent(name, k -> new ArrayList(5));
                existing.add(members);
                continue;
            }
            supportedAnnotationNames.put(name, null);
        }
        return supportedAnnotationNames;
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(candidate -> {
            if (this.supportedInterceptorTypes.contains(candidate.getBeanType())) {
                return true;
            }
            AnnotationMetadata annotationMetadata = candidate.getAnnotationMetadata();
            Collection<AnnotationValue<Annotation>> interceptorValues = InterceptorBindingQualifier.resolveInterceptorAnnotationValues(annotationMetadata, null);
            if (interceptorValues.isEmpty()) {
                return false;
            }
            if (interceptorValues.size() == 1) {
                AnnotationValue<Annotation> interceptorBinding = interceptorValues.iterator().next();
                String annotationName = interceptorBinding.stringValue().orElse(null);
                if (annotationName == null) {
                    return false;
                }
                List<AnnotationValue<?>> bindingList = this.supportedAnnotationNames.get(annotationName);
                if (bindingList != null) {
                    AnnotationValue otherBinding = interceptorBinding.getAnnotation(META_BINDING_VALUES).orElse(null);
                    boolean matched = true;
                    for (AnnotationValue<?> binding : bindingList) {
                        matched = matched && (!binding.isPresent(META_BINDING_VALUES) || binding.equals(otherBinding));
                    }
                    return matched;
                }
                return this.supportedAnnotationNames.containsKey(annotationName);
            }
            boolean matched = false;
            for (AnnotationValue<Annotation> annotation : interceptorValues) {
                String annotationName = annotation.stringValue().orElse(null);
                if (annotationName == null) continue;
                List<AnnotationValue<?>> bindingList = this.supportedAnnotationNames.get(annotationName);
                if (bindingList != null) {
                    AnnotationValue<?> binding;
                    AnnotationValue otherBinding = annotation.getAnnotation(META_BINDING_VALUES).orElse(null);
                    Iterator<AnnotationValue<?>> iterator = bindingList.iterator();
                    while (iterator.hasNext() && !(matched = !(binding = iterator.next()).isPresent(META_BINDING_VALUES) || binding.equals(otherBinding))) {
                    }
                } else {
                    matched = this.supportedAnnotationNames.containsKey(annotationName);
                }
                if (!matched) continue;
                break;
            }
            return matched;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterceptorBindingQualifier that = (InterceptorBindingQualifier)o;
        return this.supportedAnnotationNames.equals(that.supportedAnnotationNames) && this.supportedInterceptorTypes.equals(that.supportedInterceptorTypes);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.supportedAnnotationNames, this.supportedInterceptorTypes);
    }

    public String toString() {
        if (CollectionUtils.isEmpty(this.supportedAnnotationNames) && CollectionUtils.isEmpty(this.supportedInterceptorTypes)) {
            return "@InterceptorBinding(NONE)";
        }
        return this.supportedAnnotationNames.keySet().stream().map(name -> "@InterceptorBinding(" + name + ")").collect(Collectors.joining(" ")) + this.supportedInterceptorTypes.stream().map(name -> "@InterceptorBinding(interceptorType = " + name + ")").collect(Collectors.joining(" "));
    }

    @NonNull
    private static Collection<AnnotationValue<Annotation>> resolveInterceptorAnnotationValues(@NonNull AnnotationMetadata annotationMetadata, @Nullable String kind) {
        List bindings = annotationMetadata.getAnnotationValuesByName("io.micronaut.aop.InterceptorBinding");
        if (CollectionUtils.isEmpty(bindings)) {
            return Collections.emptyList();
        }
        return bindings.stream().filter(av -> {
            if (av.stringValue().isEmpty()) {
                return false;
            }
            if (kind == null) {
                return true;
            }
            String specifiedkind = av.stringValue("kind").orElse(null);
            return specifiedkind == null || specifiedkind.equals(kind);
        }).toList();
    }
}

