/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.logging.impl;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.logging.LogLevel;
import io.micronaut.logging.LoggingSystem;
import io.micronaut.logging.impl.LogbackUtils;
import jakarta.inject.Singleton;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(classes={LoggerContext.class})
@Internal
public final class LogbackLoggingSystem
implements LoggingSystem {
    private static final String DEFAULT_LOGBACK_LOCATION = "logback.xml";
    private final String logbackXmlLocation;

    public LogbackLoggingSystem(@Nullable @Property(name="logback.configurationFile") String logbackExternalConfigLocation, @Nullable @Property(name="logger.config") String logbackXmlLocation) {
        this.logbackXmlLocation = logbackExternalConfigLocation != null ? logbackExternalConfigLocation : (logbackXmlLocation != null ? logbackXmlLocation : DEFAULT_LOGBACK_LOCATION);
    }

    @Override
    public void setLogLevel(String name, LogLevel level) {
        LogbackLoggingSystem.getLoggerContext().getLogger(name).setLevel(LogbackLoggingSystem.toLevel(level));
    }

    @Override
    public void refresh() {
        LoggerContext context = LogbackLoggingSystem.getLoggerContext();
        context.reset();
        LogbackUtils.configure(this.getClass().getClassLoader(), context, this.logbackXmlLocation);
    }

    private static LoggerContext getLoggerContext() {
        return (LoggerContext)LoggerFactory.getILoggerFactory();
    }

    private static Level toLevel(LogLevel logLevel) {
        if (logLevel == LogLevel.NOT_SPECIFIED) {
            return null;
        }
        return Level.valueOf(logLevel.name());
    }
}

