/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

@Internal
public final class LoomSupport {
    private static final boolean SUPPORTED;
    private static Throwable failure;
    private static final MethodHandle MH_NEW_THREAD_PER_TASK_EXECUTOR;
    private static final MethodHandle MH_OF_VIRTUAL;
    private static final MethodHandle MH_NAME;
    private static final MethodHandle MH_FACTORY;

    private LoomSupport() {
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    public static void checkSupported() {
        if (!LoomSupport.isSupported()) {
            throw new UnsupportedOperationException("Virtual threads are not supported on this JVM, you may have to pass --enable-preview", failure);
        }
    }

    public static ExecutorService newThreadPerTaskExecutor(ThreadFactory threadFactory) {
        LoomSupport.checkSupported();
        try {
            return MH_NEW_THREAD_PER_TASK_EXECUTOR.invokeExact(threadFactory);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static ThreadFactory newVirtualThreadFactory(String namePrefix) {
        LoomSupport.checkSupported();
        try {
            Object builder = MH_OF_VIRTUAL.invoke();
            builder = MH_NAME.invoke(builder, namePrefix, 1L);
            return MH_FACTORY.invoke(builder);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        boolean sup;
        MethodHandle factory;
        MethodHandle name;
        MethodHandle ofVirtual;
        MethodHandle newThreadPerTaskExecutor;
        try {
            newThreadPerTaskExecutor = MethodHandles.lookup().findStatic(Executors.class, "newThreadPerTaskExecutor", MethodType.methodType(ExecutorService.class, ThreadFactory.class));
            Class<?> builderCl = Class.forName("java.lang.Thread$Builder");
            Class<?> ofVirtualCl = Class.forName("java.lang.Thread$Builder$OfVirtual");
            ofVirtual = MethodHandles.lookup().findStatic(Thread.class, "ofVirtual", MethodType.methodType(ofVirtualCl));
            name = MethodHandles.lookup().findVirtual(builderCl, "name", MethodType.methodType(builderCl, String.class, Long.TYPE));
            factory = MethodHandles.lookup().findVirtual(builderCl, "factory", MethodType.methodType(ThreadFactory.class));
            ofVirtual.invoke();
            sup = true;
        }
        catch (Throwable e) {
            newThreadPerTaskExecutor = null;
            ofVirtual = null;
            name = null;
            factory = null;
            sup = false;
            failure = e;
        }
        SUPPORTED = sup;
        MH_NEW_THREAD_PER_TASK_EXECUTOR = newThreadPerTaskExecutor;
        MH_OF_VIRTUAL = ofVirtual;
        MH_NAME = name;
        MH_FACTORY = factory;
    }

    @Internal
    public static class LoomCondition
    implements Condition {
        @Override
        public boolean matches(ConditionContext context) {
            if (LoomSupport.isSupported()) {
                return true;
            }
            context.fail("Virtual threads support not available: " + failure.getMessage());
            return false;
        }
    }
}

