/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.serde.ObjectMappers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public interface ObjectMapper
extends JsonMapper {
    @Override
    @Nullable
    default public <T> T readValue(@NonNull InputStream inputStream, @NonNull Class<T> type) throws IOException {
        Objects.requireNonNull(type, "Type cannot be null");
        return this.readValue(inputStream, Argument.of(type));
    }

    @Nullable
    default public <T> T readValue(@NonNull byte[] byteArray, @NonNull Class<T> type) throws IOException {
        Objects.requireNonNull(type, "Type cannot be null");
        return this.readValue(byteArray, Argument.of(type));
    }

    @Override
    @Nullable
    default public <T> T readValue(@NonNull String string, @NonNull Class<T> type) throws IOException {
        Objects.requireNonNull(type, "Type cannot be null");
        return this.readValue(string, Argument.of(type));
    }

    @Override
    default public JsonMapper cloneWithFeatures(JsonFeatures features) {
        return this;
    }

    @NonNull
    default public <T> String writeValueAsString(@NonNull Argument<T> type, @Nullable T object) throws IOException {
        return this.writeValueAsString(type, object, StandardCharsets.UTF_8);
    }

    @NonNull
    default public <T> String writeValueAsString(@NonNull Argument<T> type, @Nullable T object, Charset charset) throws IOException {
        Objects.requireNonNull(charset, "Charset cannot be null");
        byte[] bytes = this.writeValueAsBytes(type, object);
        return new String(bytes, charset);
    }

    @NonNull
    public static ObjectMapper getDefault() {
        return ObjectMappers.resolveDefault();
    }

    @NonNull
    public static CloseableObjectMapper create(Map<String, Object> configuration, String ... packageNames) {
        return ObjectMappers.create(configuration, packageNames);
    }

    public static interface CloseableObjectMapper
    extends ObjectMapper,
    AutoCloseable {
        @Override
        public void close();
    }
}

