/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.dockerfile;

import com.github.dockerjava.api.exception.DockerClientException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.testcontainers.shaded.com.github.dockerjava.core.GoLangFileMatch;
import org.testcontainers.shaded.com.github.dockerjava.core.dockerfile.DockerfileStatement;
import org.testcontainers.shaded.com.github.dockerjava.core.exception.GoLangFileMatchException;
import org.testcontainers.shaded.com.github.dockerjava.core.util.CompressArchiveUtil;
import org.testcontainers.shaded.com.github.dockerjava.core.util.FilePathUtil;
import org.testcontainers.shaded.com.google.common.base.Function;
import org.testcontainers.shaded.com.google.common.base.MoreObjects;
import org.testcontainers.shaded.com.google.common.base.Optional;
import org.testcontainers.shaded.com.google.common.collect.Collections2;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;
import org.testcontainers.shaded.org.apache.commons.io.FilenameUtils;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;

public class Dockerfile {
    public final File dockerFile;
    private final File baseDirectory;

    public Dockerfile(File dockerFile, File baseDirectory) {
        if (!dockerFile.exists()) {
            throw new IllegalStateException(String.format("Dockerfile %s does not exist", dockerFile.getAbsolutePath()));
        }
        if (!dockerFile.isFile()) {
            throw new IllegalStateException(String.format("Dockerfile %s is not a file", dockerFile.getAbsolutePath()));
        }
        this.dockerFile = dockerFile;
        if (!baseDirectory.exists()) {
            throw new IllegalStateException(String.format("Base directory %s does not exist", baseDirectory.getAbsolutePath()));
        }
        if (!baseDirectory.isDirectory()) {
            throw new IllegalStateException(String.format("Base directory %s is not a directory", baseDirectory.getAbsolutePath()));
        }
        this.baseDirectory = baseDirectory;
    }

    public Iterable<DockerfileStatement> getStatements() throws IOException {
        List<String> dockerFileContent = FileUtils.readLines(this.dockerFile);
        if (dockerFileContent.size() <= 0) {
            throw new DockerClientException(String.format("Dockerfile %s is empty", this.dockerFile));
        }
        Collection<Optional<? extends DockerfileStatement>> optionals = Collections2.transform(dockerFileContent, new LineTransformer());
        return Optional.presentInstances(optionals);
    }

    public List<String> getIgnores() throws IOException {
        ArrayList<String> ignores = new ArrayList<String>();
        File dockerIgnoreFile = new File(this.baseDirectory, ".dockerignore");
        if (dockerIgnoreFile.exists()) {
            int lineNumber = 0;
            List<String> dockerIgnoreFileContent = FileUtils.readLines(dockerIgnoreFile);
            for (String pattern : dockerIgnoreFileContent) {
                ++lineNumber;
                if ((pattern = pattern.trim()).isEmpty()) continue;
                pattern = FilenameUtils.normalize(pattern);
                try {
                    ignores.add(pattern);
                }
                catch (GoLangFileMatchException e) {
                    throw new DockerClientException(String.format("Invalid pattern '%s' on line %s in .dockerignore file", pattern, lineNumber));
                }
            }
        }
        return ignores;
    }

    public ScannedResult parse() throws IOException {
        return new ScannedResult();
    }

    public class ScannedResult {
        final List<String> ignores;
        final List<File> filesToAdd = new ArrayList<File>();

        public InputStream buildDockerFolderTar() {
            return this.buildDockerFolderTar(Dockerfile.this.baseDirectory);
        }

        public InputStream buildDockerFolderTar(File directory) {
            File dockerFolderTar = null;
            try {
                String archiveNameWithOutExtension = UUID.randomUUID().toString();
                dockerFolderTar = CompressArchiveUtil.archiveTARFiles(directory, this.filesToAdd, archiveNameWithOutExtension);
                final FileInputStream tarInputStream = FileUtils.openInputStream(dockerFolderTar);
                final File tarFile = dockerFolderTar;
                return new InputStream(){

                    @Override
                    public int available() throws IOException {
                        return tarInputStream.available();
                    }

                    @Override
                    public int read() throws IOException {
                        return tarInputStream.read();
                    }

                    @Override
                    public int read(byte[] buff, int offset, int len) throws IOException {
                        return tarInputStream.read(buff, offset, len);
                    }

                    @Override
                    public void close() throws IOException {
                        IOUtils.closeQuietly(tarInputStream);
                        FileUtils.deleteQuietly(tarFile);
                    }
                };
            }
            catch (IOException ex) {
                FileUtils.deleteQuietly(dockerFolderTar);
                throw new DockerClientException("Error occurred while preparing Docker context folder.", ex);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("ignores", this.ignores).add("filesToAdd", this.filesToAdd).toString();
        }

        public ScannedResult() throws IOException {
            this.ignores = Dockerfile.this.getIgnores();
            String matchingIgnorePattern = this.effectiveMatchingIgnorePattern(Dockerfile.this.dockerFile);
            if (matchingIgnorePattern != null) {
                throw new DockerClientException(String.format("Dockerfile is excluded by pattern '%s' in .dockerignore file", matchingIgnorePattern));
            }
            this.addFilesInDirectory(Dockerfile.this.baseDirectory);
        }

        private void addFilesInDirectory(File directory) {
            File[] files = directory.listFiles();
            if (files == null) {
                throw new DockerClientException("Failed to read build context directory: " + Dockerfile.this.baseDirectory.getAbsolutePath());
            }
            if (files.length != 0) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        this.addFilesInDirectory(f);
                        continue;
                    }
                    if (this.effectiveMatchingIgnorePattern(f) != null) continue;
                    this.filesToAdd.add(f);
                }
            } else if (!this.isBaseDirectory(directory)) {
                this.filesToAdd.add(directory);
            }
        }

        private boolean isBaseDirectory(File directory) {
            return directory.compareTo(Dockerfile.this.baseDirectory) == 0;
        }

        private List<String> matchingIgnorePatterns(String fileName) {
            ArrayList<String> matches = new ArrayList<String>();
            int lineNumber = 0;
            for (String pattern : this.ignores) {
                String goLangPattern = pattern.startsWith("!") ? pattern.substring(1) : pattern;
                ++lineNumber;
                try {
                    if (!GoLangFileMatch.match(goLangPattern, fileName)) continue;
                    matches.add(pattern);
                }
                catch (GoLangFileMatchException e) {
                    throw new DockerClientException(String.format("Invalid pattern '%s' on line %s in .dockerignore file", pattern, lineNumber));
                }
            }
            return matches;
        }

        private String effectiveMatchingIgnorePattern(File file) {
            String relativeFilename = FilenameUtils.normalize(FilePathUtil.relativize(Dockerfile.this.baseDirectory, file));
            List<String> matchingPattern = this.matchingIgnorePatterns(relativeFilename);
            if (matchingPattern.isEmpty()) {
                return null;
            }
            String lastMatchingPattern = matchingPattern.get(matchingPattern.size() - 1);
            return !lastMatchingPattern.startsWith("!") ? lastMatchingPattern : null;
        }
    }

    private static class LineTransformer
    implements Function<String, Optional<? extends DockerfileStatement>> {
        private int line = 0;

        private LineTransformer() {
        }

        @Override
        public Optional<? extends DockerfileStatement> apply(String input) {
            try {
                ++this.line;
                return DockerfileStatement.createFromLine(input);
            }
            catch (Exception ex) {
                throw new DockerClientException("Error on dockerfile line " + this.line);
            }
        }
    }
}

