/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.exec;

import com.github.dockerjava.api.command.ListSwarmNodesCmd;
import com.github.dockerjava.api.model.SwarmNode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import org.testcontainers.shaded.com.github.dockerjava.core.MediaType;
import org.testcontainers.shaded.com.github.dockerjava.core.WebTarget;
import org.testcontainers.shaded.com.github.dockerjava.core.exec.AbstrSyncDockerCmdExec;
import org.testcontainers.shaded.com.github.dockerjava.core.util.FiltersEncoder;

public class ListSwarmNodesCmdExec
extends AbstrSyncDockerCmdExec<ListSwarmNodesCmd, List<SwarmNode>>
implements ListSwarmNodesCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListSwarmNodesCmdExec.class);

    public ListSwarmNodesCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<SwarmNode> execute(ListSwarmNodesCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/nodes");
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", FiltersEncoder.jsonEncode(command.getFilters()));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<SwarmNode> nodes = webTarget.request().accept(MediaType.APPLICATION_JSON).get(new TypeReference<List<SwarmNode>>(){});
        LOGGER.trace("Response: {}", (Object)nodes);
        return nodes;
    }
}

