/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.async.propagation;

import io.micronaut.core.propagation.PropagatedContext;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.util.context.Context;

public final class ReactivePropagation {
    private ReactivePropagation() {
    }

    public static <T> Publisher<T> propagate(final PropagatedContext propagatedContext, final Publisher<T> actual) {
        if (actual instanceof CorePublisher) {
            return new CorePublisher<T>(){

                @Override
                public void subscribe(CoreSubscriber<? super T> subscriber) {
                    CorePublisher actualCorePublisher = (CorePublisher)actual;
                    try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                        actualCorePublisher.subscribe(subscriber);
                    }
                }

                @Override
                public void subscribe(Subscriber<? super T> subscriber) {
                    if (subscriber instanceof CoreSubscriber) {
                        CoreSubscriber coreSubscriber = (CoreSubscriber)subscriber;
                        this.subscribe(coreSubscriber);
                        return;
                    }
                    try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                        actual.subscribe(subscriber);
                    }
                }
            };
        }
        return subscriber -> {
            try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                actual.subscribe(subscriber);
            }
        };
    }

    public static <T> Subscriber<T> propagate(final PropagatedContext propagatedContext, final Subscriber<T> actual) {
        return new CoreSubscriber<T>(){

            @Override
            public Context currentContext() {
                if (actual instanceof CoreSubscriber) {
                    return ((CoreSubscriber)actual).currentContext();
                }
                return CoreSubscriber.super.currentContext();
            }

            @Override
            public void onSubscribe(Subscription s) {
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    actual.onSubscribe(s);
                }
            }

            @Override
            public void onNext(T t) {
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    actual.onNext(t);
                }
            }

            @Override
            public void onError(Throwable t) {
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    actual.onError(t);
                }
            }

            @Override
            public void onComplete() {
                try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
                    actual.onComplete();
                }
            }
        };
    }
}

