/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.netty.NettyHttpParameters;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.stream.DefaultStreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.DefaultAttributeMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;

@Internal
public abstract class AbstractNettyHttpRequest<B>
extends DefaultAttributeMap
implements HttpRequest<B>,
NettyHttpRequestBuilder {
    protected final io.netty.handler.codec.http.HttpRequest nettyRequest;
    protected final ConversionService conversionService;
    protected final HttpMethod httpMethod;
    protected final URI uri;
    protected final String httpMethodName;
    private NettyHttpParameters httpParameters;
    private Optional<MediaType> mediaType;
    private Charset charset;
    private Optional<Locale> locale;
    private String path;
    private Collection<MediaType> accept;

    public AbstractNettyHttpRequest(io.netty.handler.codec.http.HttpRequest nettyRequest, ConversionService conversionService) {
        this.nettyRequest = nettyRequest;
        this.conversionService = conversionService;
        URI fullUri = URI.create(nettyRequest.uri());
        if (fullUri.getAuthority() != null || fullUri.getScheme() != null) {
            try {
                fullUri = new URI(null, null, fullUri.getPath(), fullUri.getQuery(), fullUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.uri = fullUri;
        this.httpMethodName = nettyRequest.method().name();
        this.httpMethod = HttpMethod.parse(this.httpMethodName);
    }

    @Override
    @NonNull
    public io.netty.handler.codec.http.HttpRequest toHttpRequest() {
        return this.nettyRequest;
    }

    @Override
    @NonNull
    public FullHttpRequest toFullHttpRequest() {
        if (this.nettyRequest instanceof FullHttpRequest) {
            return (FullHttpRequest)this.nettyRequest;
        }
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(this.nettyRequest.protocolVersion(), this.nettyRequest.method(), this.nettyRequest.uri());
        httpRequest.headers().setAll(this.nettyRequest.headers());
        return httpRequest;
    }

    @Override
    @NonNull
    public StreamedHttpRequest toStreamHttpRequest() {
        if (this.isStream()) {
            return (StreamedHttpRequest)this.nettyRequest;
        }
        if (this.nettyRequest instanceof FullHttpRequest) {
            return new DefaultStreamedHttpRequest(HttpVersion.HTTP_1_1, this.nettyRequest.method(), this.nettyRequest.uri(), true, Publishers.just(new DefaultLastHttpContent(((FullHttpRequest)this.nettyRequest).content())));
        }
        return new DefaultStreamedHttpRequest(HttpVersion.HTTP_1_1, this.nettyRequest.method(), this.nettyRequest.uri(), true, Publishers.just(LastHttpContent.EMPTY_LAST_CONTENT));
    }

    @Override
    public boolean isStream() {
        return this.nettyRequest instanceof StreamedHttpRequest;
    }

    public io.netty.handler.codec.http.HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpParameters getParameters() {
        NettyHttpParameters params = this.httpParameters;
        if (params == null) {
            AbstractNettyHttpRequest abstractNettyHttpRequest = this;
            synchronized (abstractNettyHttpRequest) {
                params = this.httpParameters;
                if (params == null) {
                    this.httpParameters = params = this.decodeParameters();
                }
            }
        }
        return params;
    }

    @Override
    public Collection<MediaType> accept() {
        if (this.accept == null) {
            this.accept = HttpRequest.super.accept();
        }
        return this.accept;
    }

    @Override
    public Optional<MediaType> getContentType() {
        if (this.mediaType == null) {
            this.mediaType = HttpRequest.super.getContentType();
        }
        return this.mediaType;
    }

    @Override
    public Charset getCharacterEncoding() {
        if (this.charset == null) {
            this.charset = this.initCharset(HttpRequest.super.getCharacterEncoding());
        }
        return this.charset;
    }

    @Override
    public Optional<Locale> getLocale() {
        if (this.locale == null) {
            this.locale = HttpRequest.super.getLocale();
        }
        return this.locale;
    }

    @Override
    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPath() {
        String p = this.path;
        if (p == null) {
            AbstractNettyHttpRequest abstractNettyHttpRequest = this;
            synchronized (abstractNettyHttpRequest) {
                p = this.path;
                if (p == null) {
                    this.path = p = this.decodePath();
                }
            }
        }
        return p;
    }

    protected abstract Charset initCharset(Charset var1);

    protected final QueryStringDecoder createDecoder(URI uri) {
        Charset cs = this.getCharacterEncoding();
        return cs != null ? new QueryStringDecoder(uri, cs) : new QueryStringDecoder(uri);
    }

    private String decodePath() {
        QueryStringDecoder queryStringDecoder = this.createDecoder(this.uri);
        return queryStringDecoder.rawPath();
    }

    private NettyHttpParameters decodeParameters() {
        QueryStringDecoder queryStringDecoder = this.createDecoder(this.uri);
        return new NettyHttpParameters(queryStringDecoder.parameters(), this.conversionService, null);
    }

    @Override
    public String getMethodName() {
        return this.httpMethodName;
    }
}

