/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.DynamicMessageBodyWriter;
import io.micronaut.http.body.MediaTypeProvider;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.context.ServerHttpRequestContext;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.body.NettyBodyWriter;
import io.micronaut.http.netty.body.NettyWriteContext;
import io.micronaut.http.netty.stream.JsonSubscriber;
import io.micronaut.http.netty.stream.StreamedHttpMessage;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.netty.DelegateStreamedHttpResponse;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyRequestLifecycle;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.handler.PipeliningServerHandler;
import io.micronaut.http.server.netty.handler.RequestHandler;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Internal
@ChannelHandler.Sharable
public final class RoutingInBoundHandler
implements RequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingInBoundHandler.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection (?:reset|closed|abort|broken)|broken pipe).*$", 2);
    final StaticResourceResolver staticResourceResolver;
    final NettyHttpServerConfiguration serverConfiguration;
    final HttpContentProcessorResolver httpContentProcessorResolver;
    final RequestArgumentSatisfier requestArgumentSatisfier;
    final Supplier<ExecutorService> ioExecutorSupplier;
    final boolean multipartEnabled;
    final MessageBodyHandlerRegistry messageBodyHandlerRegistry;
    ExecutorService ioExecutor;
    final ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher;
    final RouteExecutor routeExecutor;
    final ConversionService conversionService;

    RoutingInBoundHandler(NettyHttpServerConfiguration serverConfiguration, NettyEmbeddedServices embeddedServerContext, Supplier<ExecutorService> ioExecutor, HttpContentProcessorResolver httpContentProcessorResolver, ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher, ConversionService conversionService) {
        this.staticResourceResolver = embeddedServerContext.getStaticResourceResolver();
        this.messageBodyHandlerRegistry = embeddedServerContext.getMessageBodyHandlerRegistry();
        this.ioExecutorSupplier = ioExecutor;
        this.requestArgumentSatisfier = embeddedServerContext.getRequestArgumentSatisfier();
        this.serverConfiguration = serverConfiguration;
        this.httpContentProcessorResolver = httpContentProcessorResolver;
        this.terminateEventPublisher = terminateEventPublisher;
        Optional<Boolean> isMultiPartEnabled = serverConfiguration.getMultipart().getEnabled();
        this.multipartEnabled = isMultiPartEnabled.isEmpty() || isMultiPartEnabled.get() != false;
        this.routeExecutor = embeddedServerContext.getRouteExecutor();
        this.conversionService = conversionService;
    }

    private void cleanupRequest(NettyHttpRequest<?> request) {
        try {
            request.release();
        }
        finally {
            block9: {
                if (!this.terminateEventPublisher.isEmpty()) {
                    try {
                        this.terminateEventPublisher.publishEvent(new HttpRequestTerminatedEvent(request));
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) break block9;
                        LOG.error("Error publishing request terminated event: " + e.getMessage(), e);
                    }
                }
            }
        }
    }

    @Override
    public void responseWritten(Object attachment) {
        if (attachment != null) {
            this.cleanupRequest((NettyHttpRequest)attachment);
        }
    }

    @Override
    public void handleUnboundError(Throwable cause) {
        if (this.isIgnorable(cause)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Swallowed an IOException caused by client connectivity: " + cause.getMessage(), cause);
            }
            return;
        }
        if (cause instanceof SSLException || cause.getCause() instanceof SSLException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
            }
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
        }
    }

    @Override
    public void accept(ChannelHandlerContext ctx, io.netty.handler.codec.http.HttpRequest request, PipeliningServerHandler.OutboundAccess outboundAccess) {
        NettyHttpRequest mnRequest;
        try {
            mnRequest = new NettyHttpRequest(request, ctx, this.conversionService, this.serverConfiguration);
        }
        catch (IllegalArgumentException e) {
            NettyHttpRequest errorRequest = new NettyHttpRequest(new DefaultFullHttpRequest(request.protocolVersion(), request.method(), "/", Unpooled.EMPTY_BUFFER), ctx, this.conversionService, this.serverConfiguration);
            outboundAccess.attachment(errorRequest);
            try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus(new ServerHttpRequestContext(errorRequest)).propagate();){
                new NettyRequestLifecycle(this, outboundAccess, errorRequest).handleException(e.getCause() == null ? e : e.getCause());
            }
            if (request instanceof StreamedHttpRequest) {
                StreamedHttpRequest streamed = (StreamedHttpRequest)request;
                streamed.closeIfNoSubscriber();
            } else {
                ((FullHttpRequest)request).release();
            }
            return;
        }
        outboundAccess.attachment(mnRequest);
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus(new ServerHttpRequestContext(mnRequest)).propagate();){
            new NettyRequestLifecycle(this, outboundAccess, mnRequest).handleNormal();
        }
    }

    public void writeResponse(PipeliningServerHandler.OutboundAccess outboundAccess, NettyHttpRequest<?> nettyHttpRequest, MutableHttpResponse<?> response, Throwable throwable) {
        if (throwable != null) {
            response = this.routeExecutor.createDefaultErrorResponse(nettyHttpRequest, throwable);
        }
        if (response != null) {
            try {
                this.encodeHttpResponse(outboundAccess, nettyHttpRequest, response, response.body());
            }
            catch (Throwable e) {
                try {
                    response = this.routeExecutor.createDefaultErrorResponse(nettyHttpRequest, e);
                    this.encodeHttpResponse(outboundAccess, nettyHttpRequest, response, response.body());
                }
                catch (Throwable f) {
                    f.addSuppressed(e);
                    outboundAccess.closeAfterWrite();
                    try {
                        outboundAccess.writeFull(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.EMPTY_BUFFER));
                    }
                    catch (Throwable g) {
                        f.addSuppressed(g);
                    }
                    LOG.warn("Failed to encode error response", f);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getIoExecutor() {
        ExecutorService executor = this.ioExecutor;
        if (executor == null) {
            RoutingInBoundHandler routingInBoundHandler = this;
            synchronized (routingInBoundHandler) {
                executor = this.ioExecutor;
                if (executor == null) {
                    this.ioExecutor = executor = this.ioExecutorSupplier.get();
                }
            }
        }
        return executor;
    }

    private void encodeHttpResponse(PipeliningServerHandler.OutboundAccess outboundAccess, NettyHttpRequest<?> nettyRequest, MutableHttpResponse<?> response, Object body) {
        if (nettyRequest.getMethod() != HttpMethod.HEAD && body != null) {
            Argument<Object> actualResponseType;
            RouteInfo routeInfo = response.getAttribute(HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
            if (Publishers.isConvertibleToPublisher(body)) {
                response.body((Object)null);
                DelegateStreamedHttpResponse streamedResponse = new DelegateStreamedHttpResponse(this.toNettyResponse(response), this.mapToHttpContent(nettyRequest, response, body, routeInfo, nettyRequest.getChannelHandlerContext()));
                this.writeStreamedWithErrorHandling(nettyRequest, outboundAccess, streamedResponse);
                return;
            }
            MessageBodyWriter messageBodyWriter = response.getBodyWriter().orElse(null);
            MediaType responseMediaType = response.getContentType().orElse(null);
            Argument<Object> responseBodyType = routeInfo != null ? routeInfo.getResponseBodyType() : Argument.of(body.getClass());
            if (responseMediaType == null) {
                if (body instanceof MediaTypeProvider) {
                    MediaTypeProvider mediaTypeProvider = (MediaTypeProvider)body;
                    responseMediaType = mediaTypeProvider.getMediaType();
                } else {
                    responseMediaType = routeInfo != null ? this.routeExecutor.resolveDefaultResponseContentType(nettyRequest, routeInfo) : MediaType.APPLICATION_JSON_TYPE;
                }
            }
            if (messageBodyWriter == null) {
                messageBodyWriter = this.messageBodyHandlerRegistry.findWriter(responseBodyType, Collections.singletonList(responseMediaType)).orElse(null);
            }
            if (messageBodyWriter == null || !responseBodyType.isInstance(body) || !messageBodyWriter.isWriteable(responseBodyType, responseMediaType)) {
                messageBodyWriter = new DynamicMessageBodyWriter(this.messageBodyHandlerRegistry, List.of(responseMediaType));
                actualResponseType = Argument.of(body.getClass());
            } else {
                actualResponseType = responseBodyType;
            }
            NettyBodyWriter<Object> closure = this.wrap(messageBodyWriter);
            this.handleMissingConnectionHeader(response, nettyRequest, outboundAccess);
            if (closure.isBlocking()) {
                MediaType finalResponseMediaType = responseMediaType;
                this.getIoExecutor().execute(() -> this.writeNettyMessageBody(nettyRequest, response, actualResponseType, finalResponseMediaType, body, closure, outboundAccess));
            } else {
                this.writeNettyMessageBody(nettyRequest, response, actualResponseType, responseMediaType, body, closure, outboundAccess);
            }
        } else {
            response.body((Object)null);
            this.writeFinalNettyResponse(response, nettyRequest, outboundAccess);
        }
    }

    private void writeNettyMessageBody(NettyHttpRequest<?> nettyRequest, MutableHttpResponse<Object> response, Argument<Object> responseBodyType, MediaType mediaType, Object body, NettyBodyWriter<Object> nettyMessageBodyWriter, PipeliningServerHandler.OutboundAccess outboundAccess) {
        try {
            nettyMessageBodyWriter.writeTo(nettyRequest, response, responseBodyType, mediaType, body, outboundAccess);
        }
        catch (CodecException e) {
            MutableHttpResponse<?> errorResponse = this.routeExecutor.createDefaultErrorResponse(nettyRequest, e);
            MediaType t = errorResponse.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
            this.wrap(new DynamicMessageBodyWriter(this.messageBodyHandlerRegistry, List.of(t))).writeTo(nettyRequest, errorResponse, Argument.OBJECT_ARGUMENT, t, errorResponse.body(), outboundAccess);
        }
    }

    private Flux<HttpContent> mapToHttpContent(NettyHttpRequest<?> request, MutableHttpResponse<?> response, Object body, RouteInfo<Object> routeInfo, ChannelHandlerContext context) {
        Flux<HttpContent> httpContentPublisher;
        MediaType mediaType = response.getContentType().orElse(null);
        NettyByteBufferFactory byteBufferFactory = new NettyByteBufferFactory(context.alloc());
        Flux<Object> bodyPublisher = Flux.from(Publishers.convertPublisher(this.conversionService, body, Publisher.class));
        boolean isJson = false;
        if (routeInfo != null) {
            if (mediaType == null) {
                mediaType = this.routeExecutor.resolveDefaultResponseContentType(request, routeInfo);
            }
            isJson = mediaType != null && mediaType.getExtension().equals("json") && routeInfo.isResponseBodyJsonFormattable();
            MediaType finalMediaType = mediaType;
            Argument<?> responseBodyType = routeInfo.getResponseBodyType();
            httpContentPublisher = bodyPublisher.map(message -> {
                DynamicMessageBodyWriter messageBodyWriter = routeInfo.getMessageBodyWriter();
                if (messageBodyWriter == null || !responseBodyType.isInstance(message) || !messageBodyWriter.isWriteable(responseBodyType, finalMediaType)) {
                    messageBodyWriter = new DynamicMessageBodyWriter(this.messageBodyHandlerRegistry, List.of(finalMediaType));
                }
                ByteBuffer<ByteBuf> byteBuffer = messageBodyWriter.writeTo(responseBodyType.isInstance(message) ? responseBodyType : Argument.of(message.getClass()), finalMediaType, message, (MutableHeaders)((Object)response.getHeaders()), (ByteBufferFactory<?, ?>)byteBufferFactory);
                return new DefaultHttpContent(byteBuffer.asNativeBuffer());
            });
        } else {
            MediaType finalMediaType = mediaType;
            DynamicMessageBodyWriter dynamicWriter = new DynamicMessageBodyWriter(this.messageBodyHandlerRegistry, mediaType == null ? List.of() : List.of(mediaType));
            httpContentPublisher = bodyPublisher.map(message -> new DefaultHttpContent((ByteBuf)dynamicWriter.writeTo(Argument.OBJECT_ARGUMENT, finalMediaType, message, (MutableHeaders)((Object)response.getHeaders()), (ByteBufferFactory<?, ?>)byteBufferFactory).asNativeBuffer()));
        }
        if (isJson) {
            httpContentPublisher = JsonSubscriber.lift(httpContentPublisher);
        }
        httpContentPublisher = httpContentPublisher.contextWrite(reactorContext -> reactorContext.put("micronaut.http.server.request", request));
        return httpContentPublisher;
    }

    private void writeFinalNettyResponse(MutableHttpResponse<?> message, NettyHttpRequest<?> request, PipeliningServerHandler.OutboundAccess outboundAccess) {
        StreamedHttpMessage streamed;
        this.handleMissingConnectionHeader(message, request, outboundAccess);
        io.netty.handler.codec.http.HttpResponse nettyResponse = NettyHttpResponseBuilder.toHttpResponse(message);
        io.netty.handler.codec.http.HttpRequest httpRequest = request.getNativeRequest();
        if (httpRequest instanceof StreamedHttpRequest && !(streamed = (StreamedHttpRequest)httpRequest).isConsumed()) {
            Flux.from(streamed).subscribe(ReferenceCounted::release);
        }
        if (nettyResponse instanceof StreamedHttpResponse) {
            streamed = (StreamedHttpResponse)nettyResponse;
            nettyResponse.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            this.writeStreamedWithErrorHandling(request, outboundAccess, (StreamedHttpResponse)streamed);
        } else {
            FullHttpResponse fullResponse = (FullHttpResponse)nettyResponse;
            if (PipeliningServerHandler.canHaveBody(fullResponse.status()) && request.getMethod() != HttpMethod.HEAD) {
                nettyResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fullResponse.content().readableBytes());
            }
            outboundAccess.writeFull(fullResponse);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response {} - {} {}", nettyResponse.status().code(), request.getMethodName(), request.getUri());
        }
    }

    private void writeStreamedWithErrorHandling(NettyHttpRequest<?> request, PipeliningServerHandler.OutboundAccess outboundAccess, StreamedHttpResponse streamed) {
        LazySendingSubscriber sub = new LazySendingSubscriber(request, streamed, outboundAccess);
        streamed.subscribe(sub);
    }

    private void handleMissingConnectionHeader(MutableHttpResponse<?> message, HttpRequest<?> request, PipeliningServerHandler.OutboundAccess outboundAccess) {
        NettyHttpRequest nettyRequest;
        boolean decodeError;
        boolean bl = decodeError = request instanceof NettyHttpRequest && (nettyRequest = (NettyHttpRequest)request).getNativeRequest().decoderResult().isFailure();
        if (decodeError || message.code() >= 500 && !this.serverConfiguration.isKeepAliveOnServerError()) {
            outboundAccess.closeAfterWrite();
        }
    }

    @NonNull
    private io.netty.handler.codec.http.HttpResponse toNettyResponse(HttpResponse<?> message) {
        if (message instanceof NettyHttpResponseBuilder) {
            NettyHttpResponseBuilder builder = (NettyHttpResponseBuilder)((Object)message);
            return builder.toHttpResponse();
        }
        return this.createNettyResponse(message).toHttpResponse();
    }

    @NonNull
    private NettyMutableHttpResponse<?> createNettyResponse(HttpResponse<?> message) {
        Object body = message.body();
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(this.serverConfiguration.isValidateHeaders());
        message.getHeaders().forEach(nettyHeaders::set);
        return new NettyMutableHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(message.code(), message.reason()), body instanceof ByteBuf ? body : null, this.conversionService);
    }

    private static void setResponseBody(MutableHttpResponse<?> response, ByteBuf byteBuf) {
        int len = byteBuf.readableBytes();
        HttpHeaders headers = response.getHeaders();
        headers.set(HttpHeaderNames.CONTENT_LENGTH, String.valueOf(len));
        response.body(byteBuf);
    }

    boolean isIgnorable(Throwable cause) {
        if (cause instanceof ClosedChannelException || cause.getCause() instanceof ClosedChannelException) {
            return true;
        }
        String message = cause.getMessage();
        return cause instanceof IOException && message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches();
    }

    <T> NettyBodyWriter<T> wrap(MessageBodyWriter<T> closure) {
        if (closure instanceof NettyBodyWriter) {
            NettyBodyWriter nettyClosure = (NettyBodyWriter)closure;
            return nettyClosure;
        }
        return new CompatNettyWriteClosure<T>(closure);
    }

    private final class LazySendingSubscriber
    implements Processor<HttpContent, HttpContent> {
        boolean headersSent = false;
        Subscription upstream;
        Subscriber<? super HttpContent> downstream;
        @Nullable
        HttpContent first;
        private final NettyHttpRequest<?> request;
        private final io.netty.handler.codec.http.HttpResponse headers;
        private final PipeliningServerHandler.OutboundAccess outboundAccess;

        private LazySendingSubscriber(NettyHttpRequest<?> request, io.netty.handler.codec.http.HttpResponse headers, PipeliningServerHandler.OutboundAccess outboundAccess) {
            this.request = request;
            this.headers = headers;
            this.outboundAccess = outboundAccess;
        }

        @Override
        public void subscribe(final Subscriber<? super HttpContent> s) {
            s.onSubscribe(new Subscription(){

                @Override
                public void request(long n) {
                    HttpContent first = LazySendingSubscriber.this.first;
                    if (first != null) {
                        LazySendingSubscriber.this.first = null;
                        s.onNext(first);
                        if (n != Long.MAX_VALUE && --n == 0L) {
                            return;
                        }
                    }
                    LazySendingSubscriber.this.upstream.request(n);
                }

                @Override
                public void cancel() {
                    if (LazySendingSubscriber.this.first != null) {
                        LazySendingSubscriber.this.first.release();
                        LazySendingSubscriber.this.first = null;
                    }
                    LazySendingSubscriber.this.upstream.cancel();
                }
            });
            this.downstream = s;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.upstream = s;
            s.request(1L);
        }

        @Override
        public void onNext(HttpContent httpContent) {
            if (this.headersSent) {
                this.downstream.onNext(httpContent);
            } else {
                this.first = httpContent;
                this.headersSent = true;
                this.outboundAccess.writeStreamed(this.headers, this);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.headersSent) {
                this.downstream.onError(t);
            } else {
                MutableHttpResponse<Object> response;
                if (t instanceof HttpStatusException) {
                    HttpStatusException hse = (HttpStatusException)t;
                    response = HttpResponse.status(hse.getStatus());
                    if (hse.getBody().isPresent()) {
                        response.body(hse.getBody().get());
                    } else if (hse.getMessage() != null) {
                        response.body(hse.getMessage());
                    }
                } else {
                    response = RoutingInBoundHandler.this.routeExecutor.createDefaultErrorResponse(this.request, t);
                }
                RoutingInBoundHandler.this.encodeHttpResponse(this.outboundAccess, this.request, response, response.body());
            }
        }

        @Override
        public void onComplete() {
            if (this.headersSent) {
                this.downstream.onComplete();
            } else {
                this.headersSent = true;
                this.outboundAccess.writeStreamed(this.headers, Flux.empty());
            }
        }
    }

    private final class CompatNettyWriteClosure<T>
    implements NettyBodyWriter<T> {
        private final MessageBodyWriter<T> delegate;

        CompatNettyWriteClosure(MessageBodyWriter<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isBlocking() {
            return this.delegate.isBlocking();
        }

        @Override
        public void writeTo(HttpRequest<?> request, MutableHttpResponse<T> outgoingResponse, Argument<T> type, MediaType mediaType, T object, NettyWriteContext nettyContext) throws CodecException {
            DynamicMessageBodyWriter dyn;
            MessageBodyWriter<Object> actual = this.delegate;
            MessageBodyWriter<T> messageBodyWriter = this.delegate;
            if (messageBodyWriter instanceof DynamicMessageBodyWriter && (actual = (dyn = (DynamicMessageBodyWriter)messageBodyWriter).find(type, mediaType, object)) instanceof NettyBodyWriter) {
                NettyBodyWriter nbw = (NettyBodyWriter)actual;
                nbw.writeTo(request, outgoingResponse, type, mediaType, object, nettyContext);
                return;
            }
            NettyByteBufferFactory bufferFactory = new NettyByteBufferFactory(nettyContext.alloc());
            ByteBuffer<ByteBuf> byteBuffer = actual.writeTo(type, mediaType, object, (MutableHeaders)((Object)outgoingResponse.getHeaders()), bufferFactory);
            RoutingInBoundHandler.setResponseBody(outgoingResponse, byteBuffer.asNativeBuffer());
            RoutingInBoundHandler.this.writeFinalNettyResponse(outgoingResponse, (NettyHttpRequest)request, (PipeliningServerHandler.OutboundAccess)nettyContext);
        }

        @Override
        public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
            this.delegate.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
        }

        @Override
        public ByteBuffer<?> writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
            return this.delegate.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory);
        }
    }
}

