/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.annotation.EnvironmentAnnotationMetadata;
import io.micronaut.inject.annotation.EnvironmentAnnotationValue;
import io.micronaut.inject.annotation.EnvironmentOptionalValuesMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public abstract class AbstractEnvironmentAnnotationMetadata
implements AnnotationMetadata {
    private final EnvironmentAnnotationMetadata environmentAnnotationMetadata;

    protected AbstractEnvironmentAnnotationMetadata(AnnotationMetadata targetMetadata) {
        this.environmentAnnotationMetadata = targetMetadata instanceof EnvironmentAnnotationMetadata ? (EnvironmentAnnotationMetadata)targetMetadata : new AnnotationMetadataHierarchy(targetMetadata);
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.environmentAnnotationMetadata;
    }

    @Override
    @Nullable
    public <T extends Annotation> T synthesize(@NonNull Class<T> annotationClass) {
        return this.environmentAnnotationMetadata.synthesize(annotationClass);
    }

    @Override
    @Nullable
    public <T extends Annotation> T synthesizeDeclared(@NonNull Class<T> annotationClass) {
        return this.environmentAnnotationMetadata.synthesizeDeclared(annotationClass);
    }

    @Override
    public boolean hasEvaluatedExpressions() {
        return this.environmentAnnotationMetadata.hasEvaluatedExpressions();
    }

    @Override
    public <T> Optional<T> getValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return this.environmentAnnotationMetadata.getValue(annotation, member, requiredType, o -> {
                PropertyPlaceholderResolver placeholderResolver = environment.getPlaceholderResolver();
                if (o instanceof String) {
                    String v = (String)o;
                    if (v.contains("${")) {
                        return placeholderResolver.resolveRequiredPlaceholders(v);
                    }
                } else if (o instanceof String[]) {
                    return AnnotationValue.resolveStringArray((String[])o, o1 -> {
                        String v = (String)o1;
                        if (v.contains("${")) {
                            return placeholderResolver.resolveRequiredPlaceholders(v);
                        }
                        return v;
                    });
                }
                return o;
            });
        }
        return this.environmentAnnotationMetadata.getValue(annotation, member, requiredType);
    }

    @Override
    public <T> Class<T>[] classValues(@NonNull String annotation, @NonNull String member) {
        return this.environmentAnnotationMetadata.classValues(annotation, member);
    }

    @Override
    public <T> Class<T>[] classValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return this.environmentAnnotationMetadata.classValues(annotation, member);
    }

    @Override
    public boolean isTrue(@NonNull String annotation, @NonNull String member) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return this.environmentAnnotationMetadata.isTrue(annotation, member, o -> {
                String v;
                if (o instanceof String && (v = (String)o).contains("${")) {
                    return environment.getPlaceholderResolver().resolveRequiredPlaceholders(v);
                }
                return o;
            });
        }
        return this.environmentAnnotationMetadata.isTrue(annotation, member);
    }

    @Override
    public boolean isFalse(@NonNull String annotation, @NonNull String member) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            return !this.environmentAnnotationMetadata.isTrue(annotation, member, o -> {
                String v;
                if (o instanceof String && (v = (String)o).contains("${")) {
                    return environment.getPlaceholderResolver().resolveRequiredPlaceholders(v);
                }
                return o;
            });
        }
        return !this.environmentAnnotationMetadata.isTrue(annotation, member);
    }

    @Override
    @NonNull
    public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@NonNull Class<? extends Annotation> stereotype) {
        return this.environmentAnnotationMetadata.getAnnotationTypeByStereotype(stereotype);
    }

    @Override
    @NonNull
    public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@Nullable String stereotype) {
        return this.environmentAnnotationMetadata.getAnnotationTypeByStereotype(stereotype);
    }

    @Override
    @NonNull
    public Optional<Class> classValue(@NonNull String annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.classValue(annotation, member, valueMapper);
    }

    @Override
    @NonNull
    public Optional<Class> classValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.classValue(annotation, member, valueMapper);
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(@NonNull String annotation, @NonNull String member, Class<E> enumType) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.enumValue(annotation, member, enumType, valueMapper);
    }

    @Override
    public <E extends Enum<E>> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.enumValue(annotation, member, enumType, valueMapper);
    }

    @Override
    public <E extends Enum<E>> E[] enumValues(@NonNull String annotation, @NonNull String member, Class<E> enumType) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.enumValues(annotation, member, enumType, valueMapper);
    }

    @Override
    public Optional<Boolean> booleanValue(@NonNull String annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.booleanValue(annotation, member, valueMapper);
    }

    @Override
    public Optional<Boolean> booleanValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.booleanValue(annotation, member, valueMapper);
    }

    @Override
    @NonNull
    public Optional<String> stringValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.stringValue(annotation, member, valueMapper);
    }

    @Override
    @NonNull
    public String[] stringValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        Environment environment = this.getEnvironment();
        if (environment != null) {
            PropertyPlaceholderResolver resolver = environment.getPlaceholderResolver();
            Function<Object, Object> valueMapper = val -> {
                String[] values;
                if (val instanceof CharSequence) {
                    values = new String[]{val.toString()};
                } else if (val instanceof String[]) {
                    values = (String[])val;
                } else {
                    return null;
                }
                String[] resolvedValues = Arrays.copyOf(values, values.length);
                boolean expandValues = false;
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    if (value != null && value.contains(resolver.getPrefix()) && (value = resolver.resolveRequiredPlaceholders(value)).contains(",")) {
                        expandValues = true;
                    }
                    resolvedValues[i] = value;
                }
                if (expandValues) {
                    return Stream.of(resolvedValues).flatMap(s -> {
                        if (s.contains(",")) {
                            return Arrays.stream(resolver.resolveRequiredPlaceholder((String)s, String[].class));
                        }
                        return Stream.of(s);
                    }).toArray(String[]::new);
                }
                return resolvedValues;
            };
            return this.environmentAnnotationMetadata.stringValues(annotation, member, valueMapper);
        }
        return this.environmentAnnotationMetadata.stringValues(annotation, member, null);
    }

    @Override
    @NonNull
    public Optional<String> stringValue(@NonNull String annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.stringValue(annotation, member, valueMapper);
    }

    @Override
    public OptionalLong longValue(@NonNull String annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.longValue(annotation, member, valueMapper);
    }

    @Override
    public OptionalLong longValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.longValue(annotation, member, valueMapper);
    }

    @Override
    @NonNull
    public OptionalInt intValue(@NonNull String annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.intValue(annotation, member, valueMapper);
    }

    @Override
    @NonNull
    public OptionalInt intValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.intValue(annotation, member, valueMapper);
    }

    @Override
    @NonNull
    public OptionalDouble doubleValue(@NonNull String annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.doubleValue(annotation, member, valueMapper);
    }

    @Override
    @NonNull
    public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.doubleValue(annotation, member, valueMapper);
    }

    @Override
    public boolean isTrue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return this.environmentAnnotationMetadata.isTrue(annotation, member, valueMapper);
    }

    @Override
    public boolean isFalse(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        Function<Object, Object> valueMapper = this.getEnvironmentValueMapper();
        return !this.environmentAnnotationMetadata.isTrue(annotation, member, valueMapper);
    }

    @Override
    @NonNull
    public Optional<Class<? extends Annotation>> getAnnotationType(@NonNull String name) {
        ArgumentUtils.requireNonNull("name", name);
        return this.environmentAnnotationMetadata.getAnnotationType(name);
    }

    @Override
    @NonNull
    public Optional<Class<? extends Annotation>> getAnnotationType(@NonNull String name, @NonNull ClassLoader classLoader) {
        ArgumentUtils.requireNonNull("name", name);
        return this.environmentAnnotationMetadata.getAnnotationType(name, classLoader);
    }

    @Override
    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@NonNull Class<T> annotationType) {
        ArgumentUtils.requireNonNull("annotationType", annotationType);
        Environment environment = this.getEnvironment();
        List<AnnotationValue<T>> values = this.environmentAnnotationMetadata.getAnnotationValuesByType(annotationType);
        if (environment != null) {
            return values.stream().map(entries -> new EnvironmentAnnotationValue(environment, entries)).collect(Collectors.toList());
        }
        return values;
    }

    @Override
    @NonNull
    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@NonNull Class<T> annotationType) {
        ArgumentUtils.requireNonNull("annotationType", annotationType);
        Environment environment = this.getEnvironment();
        List<AnnotationValue<T>> values = this.environmentAnnotationMetadata.getDeclaredAnnotationValuesByType(annotationType);
        if (environment != null) {
            return values.stream().map(entries -> new EnvironmentAnnotationValue(environment, entries)).collect(Collectors.toList());
        }
        return values;
    }

    @Override
    @NonNull
    public <T extends Annotation> T[] synthesizeAnnotationsByType(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        Environment environment = this.getEnvironment();
        if (environment != null) {
            List<AnnotationValue<T>> values = this.environmentAnnotationMetadata.getAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, new EnvironmentAnnotationValue(environment, entries))).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return this.environmentAnnotationMetadata.synthesizeAnnotationsByType(annotationClass);
    }

    @Override
    @NonNull
    public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        Environment environment = this.getEnvironment();
        if (environment != null) {
            List<AnnotationValue<T>> values = this.environmentAnnotationMetadata.getDeclaredAnnotationValuesByType(annotationClass);
            return (Annotation[])values.stream().map(entries -> AnnotationMetadataSupport.buildAnnotation(annotationClass, new EnvironmentAnnotationValue(environment, entries))).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
        }
        return this.environmentAnnotationMetadata.synthesizeDeclaredAnnotationsByType(annotationClass);
    }

    @Override
    public boolean hasDeclaredAnnotation(@Nullable String annotation) {
        return this.environmentAnnotationMetadata.hasDeclaredAnnotation(annotation);
    }

    @Override
    public boolean hasAnnotation(@Nullable String annotation) {
        return this.environmentAnnotationMetadata.hasAnnotation(annotation);
    }

    @Override
    public boolean hasStereotype(@Nullable String annotation) {
        return this.environmentAnnotationMetadata.hasStereotype(annotation);
    }

    @Override
    public boolean hasDeclaredStereotype(@Nullable String annotation) {
        return this.environmentAnnotationMetadata.hasDeclaredStereotype(annotation);
    }

    @Override
    @NonNull
    public List<String> getAnnotationNamesByStereotype(String stereotype) {
        return this.environmentAnnotationMetadata.getAnnotationNamesByStereotype(stereotype);
    }

    @Override
    @NonNull
    public Set<String> getAnnotationNames() {
        return this.environmentAnnotationMetadata.getAnnotationNames();
    }

    @Override
    @NonNull
    public Set<String> getDeclaredAnnotationNames() {
        return this.environmentAnnotationMetadata.getDeclaredAnnotationNames();
    }

    @Override
    @NonNull
    public List<String> getDeclaredAnnotationNamesByStereotype(String stereotype) {
        return this.environmentAnnotationMetadata.getDeclaredAnnotationNamesByStereotype(stereotype);
    }

    @Override
    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        Environment env = this.getEnvironment();
        Optional<AnnotationValue<AnnotationValue>> values = this.environmentAnnotationMetadata.findAnnotation(annotation);
        if (env != null) {
            return values.map(av -> new EnvironmentAnnotationValue(env, av));
        }
        return values;
    }

    @Override
    @NonNull
    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        Environment env = this.getEnvironment();
        Optional<AnnotationValue<AnnotationValue>> values = this.environmentAnnotationMetadata.findDeclaredAnnotation(annotation);
        if (env != null) {
            return values.map(av -> new EnvironmentAnnotationValue(env, av));
        }
        return values;
    }

    @Override
    @NonNull
    public <T> OptionalValues<T> getValues(@NonNull String annotation, @NonNull Class<T> valueType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("valueType", valueType);
        if (this.environmentAnnotationMetadata instanceof DefaultAnnotationMetadata) {
            Environment environment = this.getEnvironment();
            return this.resolveOptionalValuesForEnvironment(annotation, valueType, Collections.singleton(this.environmentAnnotationMetadata), environment);
        }
        if (this.environmentAnnotationMetadata instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadataHierarchy hierarchy = (AnnotationMetadataHierarchy)this.environmentAnnotationMetadata;
            Environment environment = this.getEnvironment();
            return this.resolveOptionalValuesForEnvironment(annotation, valueType, hierarchy, environment);
        }
        return OptionalValues.empty();
    }

    @Override
    @NonNull
    public <T> Optional<T> getDefaultValue(@NonNull String annotation, @NonNull String member, @NonNull Class<T> requiredType) {
        return this.environmentAnnotationMetadata.getDefaultValue(annotation, member, requiredType);
    }

    @Override
    @NonNull
    public <T> Optional<T> getDefaultValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        return this.environmentAnnotationMetadata.getDefaultValue(annotation, member, requiredType);
    }

    @Override
    public AnnotationMetadata copyAnnotationMetadata() {
        return this.environmentAnnotationMetadata.copyAnnotationMetadata();
    }

    @Override
    public AnnotationMetadata getTargetAnnotationMetadata() {
        return this.environmentAnnotationMetadata.getTargetAnnotationMetadata();
    }

    @Nullable
    protected abstract Environment getEnvironment();

    @Nullable
    private Function<Object, Object> getEnvironmentValueMapper() {
        Environment env = this.getEnvironment();
        if (env != null) {
            return o -> {
                String v;
                if (o instanceof String && (v = (String)o).contains("${")) {
                    return env.getPlaceholderResolver().resolveRequiredPlaceholders(v);
                }
                return o;
            };
        }
        return null;
    }

    private <T> OptionalValues<T> resolveOptionalValuesForEnvironment(String annotation, Class<T> valueType, Iterable<AnnotationMetadata> metadata, Environment environment) {
        LinkedHashMap<CharSequence, Object> finalValues = new LinkedHashMap<CharSequence, Object>();
        for (AnnotationMetadata annotationMetadata : metadata) {
            if (!(annotationMetadata instanceof DefaultAnnotationMetadata)) continue;
            Map<String, Map<CharSequence, Object>> allAnnotations = ((DefaultAnnotationMetadata)annotationMetadata).allAnnotations;
            Map<String, Map<CharSequence, Object>> allStereotypes = ((DefaultAnnotationMetadata)annotationMetadata).allStereotypes;
            if (allAnnotations == null || !StringUtils.isNotEmpty(annotation)) continue;
            this.processMap(annotation, finalValues, allStereotypes);
            this.processMap(annotation, finalValues, allAnnotations);
        }
        if (environment != null) {
            return new EnvironmentOptionalValuesMap(valueType, finalValues, environment);
        }
        return OptionalValues.of(valueType, finalValues);
    }

    private void processMap(String annotation, Map<CharSequence, Object> finalValues, Map<String, Map<CharSequence, Object>> allStereotypes) {
        Map<CharSequence, Object> values;
        if (allStereotypes != null && (values = allStereotypes.get(annotation)) != null) {
            for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
                finalValues.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
    }
}

