/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.UnsafeBeanProperty;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.GenericPlaceholder;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.InvalidPropertyFormatException;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBeanRegistry;
import io.micronaut.serde.support.deserializers.PropertiesBag;
import io.micronaut.serde.support.deserializers.SubtypedDeserBean;
import io.micronaut.serde.support.util.SerdeAnnotationUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.BiConsumer;

@Internal
class DeserBean<T> {
    private static final String JK_PROP = "com.fasterxml.jackson.annotation.JsonProperty";
    @NonNull
    public final BeanIntrospection<T> introspection;
    @Nullable
    public final PropertiesBag<T> creatorParams;
    @Nullable
    public final DerProperty<T, ?>[] creatorUnwrapped;
    @Nullable
    public final PropertiesBag<T> readProperties;
    @Nullable
    public final DerProperty<T, Object>[] unwrappedProperties;
    @Nullable
    public final AnySetter<Object> anySetter;
    public final int creatorSize;
    public final boolean ignoreUnknown;
    public final boolean delegating;
    public final boolean simpleBean;
    public final boolean recordLikeBean;
    public final ConversionService conversionService;
    private volatile boolean initialized;
    private volatile boolean initializing;

    public DeserBean(BeanIntrospection<T> introspection, Deserializer.DecoderContext decoderContext, DeserBeanRegistry deserBeanRegistry) throws SerdeException {
        this.conversionService = decoderContext.getConversionService();
        this.introspection = introspection;
        SerdeConfig.SerCreatorMode creatorMode = introspection.getConstructor().getAnnotationMetadata().enumValue(Creator.class, "mode", SerdeConfig.SerCreatorMode.class).orElse(null);
        this.delegating = creatorMode == SerdeConfig.SerCreatorMode.DELEGATING;
        Argument<?>[] constructorArguments = introspection.getConstructorArguments();
        this.creatorSize = constructorArguments.length;
        PropertyNamingStrategy entityPropertyNamingStrategy = this.getPropertyNamingStrategy(introspection, decoderContext, null);
        this.ignoreUnknown = introspection.booleanValue(SerdeConfig.SerIgnored.class, "ignoreUnknown").orElse(true);
        PropertiesBag.Builder<T> creatorPropertiesBuilder = new PropertiesBag.Builder<T>(introspection, constructorArguments.length);
        ArrayList<DerProperty<T, Object>> creatorUnwrapped = null;
        AnySetter anySetterValue = null;
        ArrayList unwrappedProperties = null;
        for (int i = 0; i < constructorArguments.length; ++i) {
            DerProperty<T, Object> derProperty;
            Argument<Object> constructorArgument = this.resolveArgument(constructorArguments[i]);
            AnnotationMetadata annotationMetadata = DeserBean.resolveArgumentMetadata(introspection, constructorArgument, constructorArgument.getAnnotationMetadata());
            if (annotationMetadata.isTrue(SerdeConfig.class, "ignored")) continue;
            if (annotationMetadata.isAnnotationPresent(SerdeConfig.SerAnySetter.class)) {
                anySetterValue = new AnySetter(constructorArgument, i);
                String n = constructorArgument.getName();
                creatorPropertiesBuilder.register(n, new DerProperty<T, Object>(this.conversionService, introspection, i, n, constructorArgument, null, null, null), false);
                continue;
            }
            PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(annotationMetadata, decoderContext, entityPropertyNamingStrategy);
            String propertyName = this.resolveName(constructorArgument, annotationMetadata, propertyNamingStrategy);
            Argument constructorWithPropertyArgument = Argument.of(constructorArgument.getType(), constructorArgument.getName(), annotationMetadata, constructorArgument.getTypeParameters());
            boolean bl = annotationMetadata.hasAnnotation(SerdeConfig.SerUnwrapped.class);
            if (bl) {
                if (creatorUnwrapped == null) {
                    creatorUnwrapped = new ArrayList<DerProperty<T, Object>>();
                }
                DeserBean<Object> unwrapped = deserBeanRegistry.getDeserializableBean(constructorArgument, decoderContext);
                creatorUnwrapped.add(new DerProperty<T, Object>(this.conversionService, introspection, i, propertyName, constructorWithPropertyArgument, null, null, unwrapped));
                String prefix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "prefix").orElse("");
                String suffix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "suffix").orElse("");
                PropertiesBag<T> unwrappedCreatorParams = unwrapped.creatorParams;
                if (unwrappedCreatorParams != null) {
                    for (Map.Entry<String, DerProperty<T, Object>> e : unwrappedCreatorParams.getProperties()) {
                        String resolved = prefix + e.getKey() + suffix;
                        creatorPropertiesBuilder.register(resolved, e.getValue(), false);
                    }
                }
                derProperty = new DerProperty<T, Object>(this.conversionService, introspection, i, propertyName, constructorWithPropertyArgument, null, null, unwrapped);
            } else {
                derProperty = new DerProperty(this.conversionService, introspection, i, propertyName, constructorWithPropertyArgument, introspection.getProperty(propertyName).orElse(null), null, null);
            }
            creatorPropertiesBuilder.register(propertyName, derProperty, true);
        }
        List<BeanProperty> beanProperties = introspection.getBeanProperties().stream().filter(bp -> {
            AnnotationMetadata annotationMetadata = bp.getAnnotationMetadata();
            return !bp.isReadOnly() && annotationMetadata.booleanValue(SerdeConfig.class, "writeOnly").orElse(false) == false && annotationMetadata.booleanValue(SerdeConfig.class, "ignored").orElse(false) == false;
        }).toList();
        Collection<BeanMethod<T, Object>> beanMethods = introspection.getBeanMethods();
        ArrayList<BeanMethod<T, Object>> jsonSetters = new ArrayList<BeanMethod<T, Object>>(beanMethods.size());
        BeanMethod<T, Object> anySetter = null;
        for (BeanMethod<T, Object> method : beanMethods) {
            if (method.isAnnotationPresent(SerdeConfig.SerSetter.class)) {
                jsonSetters.add(method);
                continue;
            }
            if (!method.isAnnotationPresent(SerdeConfig.SerAnySetter.class) || !ArrayUtils.isNotEmpty(method.getArguments())) continue;
            anySetter = method;
        }
        if (anySetterValue == null) {
            AnySetter anySetter2 = anySetterValue = anySetter != null ? new AnySetter(anySetter) : null;
        }
        if (CollectionUtils.isNotEmpty(beanProperties) || CollectionUtils.isNotEmpty(jsonSetters)) {
            PropertyNamingStrategy propertyNamingStrategy;
            PropertiesBag.Builder<T> readPropertiesBuilder = new PropertiesBag.Builder<T>(introspection);
            for (int i = 0; i < beanProperties.size(); ++i) {
                BeanProperty beanProperty = beanProperties.get(i);
                propertyNamingStrategy = this.getPropertyNamingStrategy(beanProperty.getAnnotationMetadata(), decoderContext, entityPropertyNamingStrategy);
                AnnotationMetadata annotationMetadata = beanProperty.getAnnotationMetadata();
                if (annotationMetadata.isAnnotationPresent(SerdeConfig.SerAnySetter.class)) {
                    anySetterValue = new AnySetter(beanProperty);
                    continue;
                }
                boolean isUnwrapped = annotationMetadata.hasAnnotation(SerdeConfig.SerUnwrapped.class);
                Argument t = this.resolveArgument(beanProperty.asArgument());
                if (isUnwrapped) {
                    PropertiesBag<T> unwrappedCreatorParams;
                    if (unwrappedProperties == null) {
                        unwrappedProperties = new ArrayList();
                    }
                    DeserBean unwrapped = deserBeanRegistry.getDeserializableBean(t, decoderContext);
                    AnnotationMetadataHierarchy combinedMetadata = new AnnotationMetadataHierarchy(annotationMetadata, t.getAnnotationMetadata());
                    unwrappedProperties.add(new DerProperty(this.conversionService, introspection, i, t.getName(), t, combinedMetadata, beanProperty, null, unwrapped));
                    String prefix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "prefix").orElse("");
                    String suffix = annotationMetadata.stringValue(SerdeConfig.SerUnwrapped.class, "suffix").orElse("");
                    PropertiesBag<T> unwrappedProps = unwrapped.readProperties;
                    if (unwrappedProps != null) {
                        for (Map.Entry<String, DerProperty<T, Object>> e : unwrappedProps.getProperties()) {
                            String resolved = prefix + e.getKey() + suffix;
                            readPropertiesBuilder.register(resolved, e.getValue(), false);
                        }
                    }
                    if ((unwrappedCreatorParams = unwrapped.creatorParams) == null) continue;
                    for (Map.Entry<String, DerProperty<T, Object>> e : unwrappedCreatorParams.getProperties()) {
                        String resolved = prefix + e.getKey() + suffix;
                        creatorPropertiesBuilder.register(resolved, e.getValue(), false);
                    }
                    continue;
                }
                String jsonProperty = this.resolveName(beanProperty, annotationMetadata, propertyNamingStrategy);
                DerProperty derProperty = new DerProperty(this.conversionService, introspection, i, jsonProperty, t, beanProperty, null, null);
                readPropertiesBuilder.register(jsonProperty, derProperty, true);
            }
            for (final BeanMethod beanMethod : jsonSetters) {
                propertyNamingStrategy = this.getPropertyNamingStrategy(beanMethod.getAnnotationMetadata(), decoderContext, entityPropertyNamingStrategy);
                String property = this.resolveName(new AnnotatedElement(){

                    @Override
                    public String getName() {
                        return NameUtils.getPropertyNameForSetter(beanMethod.getName());
                    }

                    @Override
                    public AnnotationMetadata getAnnotationMetadata() {
                        return beanMethod.getAnnotationMetadata();
                    }
                }, beanMethod.getAnnotationMetadata(), propertyNamingStrategy);
                Argument<?> argument = this.resolveArgument(beanMethod.getArguments()[0]);
                DerProperty derProperty = new DerProperty(this.conversionService, introspection, 0, property, argument, null, beanMethod, null);
                readPropertiesBuilder.register(property, derProperty, true);
            }
            this.readProperties = readPropertiesBuilder.build();
        } else {
            this.readProperties = null;
        }
        this.anySetter = anySetterValue;
        this.creatorParams = creatorPropertiesBuilder.build();
        this.creatorUnwrapped = creatorUnwrapped != null ? creatorUnwrapped.toArray(new DerProperty[0]) : null;
        this.unwrappedProperties = unwrappedProperties != null ? unwrappedProperties.toArray(new DerProperty[0]) : null;
        this.simpleBean = this.isSimpleBean();
        this.recordLikeBean = this.isRecordLikeBean();
    }

    public boolean isSubtyped() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(Deserializer.DecoderContext decoderContext) throws SerdeException {
        if (!this.initialized) {
            DeserBean deserBean = this;
            synchronized (deserBean) {
                if (!this.initialized && !this.initializing) {
                    this.initializing = true;
                    this.initializeInternal(decoderContext);
                    this.initialized = true;
                    this.initializing = false;
                }
            }
        }
    }

    private void initializeInternal(Deserializer.DecoderContext decoderContext) throws SerdeException {
        DerProperty<T, Object> property;
        List<Map.Entry<String, DerProperty<T, Object>>> properties;
        if (this.readProperties != null) {
            properties = this.readProperties.getProperties();
            for (Map.Entry<String, DerProperty<T, Object>> e : properties) {
                property = e.getValue();
                this.initProperty(property, decoderContext);
            }
        }
        if (this.creatorParams != null) {
            properties = this.creatorParams.getProperties();
            for (Map.Entry<String, DerProperty<T, Object>> e : properties) {
                property = e.getValue();
                this.initProperty(property, decoderContext);
            }
        }
        if (this.anySetter != null) {
            Deserializer<Object> deserializer = this.anySetter.deserializer = this.anySetter.valueType.equalsType(Argument.OBJECT_ARGUMENT) ? null : DeserBean.findDeserializer(decoderContext, this.anySetter.valueType);
        }
        if (this.unwrappedProperties != null) {
            for (DerProperty<T, Object> unwrappedProperty : this.unwrappedProperties) {
                this.initProperty(unwrappedProperty, decoderContext);
            }
        }
    }

    private boolean isSimpleBean() {
        if (this.delegating || this instanceof SubtypedDeserBean || this.creatorParams != null || this.creatorUnwrapped != null || this.unwrappedProperties != null || this.anySetter != null) {
            return false;
        }
        if (this.readProperties != null) {
            for (Map.Entry<String, DerProperty<T, Object>> e : this.readProperties.getProperties()) {
                DerProperty<T, Object> property = e.getValue();
                if (!property.isAnySetter && property.views == null && property.managedRef == null && this.introspection == property.instrospection && property.backRef == null && property.beanProperty != null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isRecordLikeBean() {
        if (this.delegating || this instanceof SubtypedDeserBean || this.readProperties != null || this.creatorUnwrapped != null || this.unwrappedProperties != null || this.anySetter != null) {
            return false;
        }
        if (this.creatorParams != null) {
            for (Map.Entry<String, DerProperty<T, Object>> e : this.creatorParams.getProperties()) {
                DerProperty<T, Object> property = e.getValue();
                if ((property.beanProperty == null || property.beanProperty.isReadOnly()) && !property.isAnySetter && property.views == null && property.managedRef == null && this.introspection == property.instrospection && property.backRef == null) continue;
                return false;
            }
        }
        return true;
    }

    private void initProperty(DerProperty<T, Object> property, Deserializer.DecoderContext decoderContext) throws SerdeException {
        property.deserializer = DeserBean.findDeserializer(decoderContext, property.argument);
    }

    private PropertyNamingStrategy getPropertyNamingStrategy(AnnotationMetadata annotationMetadata, Deserializer.DecoderContext decoderContext, PropertyNamingStrategy defaultNamingStrategy) throws SerdeException {
        Class namingStrategyClass = annotationMetadata.classValue(SerdeConfig.class, "runtimeNaming").orElse(null);
        return namingStrategyClass == null ? defaultNamingStrategy : decoderContext.findNamingStrategy(namingStrategyClass);
    }

    private <A> Argument<A> resolveArgument(Argument<A> argument) {
        Map<String, Argument<?>> bounds;
        if ((argument instanceof GenericPlaceholder || argument.hasTypeVariables()) && !(bounds = this.getBounds()).isEmpty()) {
            return this.resolveArgument(argument, bounds);
        }
        return argument;
    }

    private <A> Argument<A> resolveArgument(Argument<A> argument, Map<String, Argument<?>> bounds) {
        Argument[] declaredParameters = argument.getTypeParameters();
        Argument<?>[] typeParameters = this.resolveParameters(bounds, declaredParameters);
        if (argument instanceof GenericPlaceholder) {
            GenericPlaceholder gp = (GenericPlaceholder)argument;
            Argument<?> resolved = bounds.get(gp.getVariableName());
            if (resolved != null) {
                return Argument.of(resolved.getType(), argument.getName(), argument.getAnnotationMetadata(), typeParameters);
            }
            if (typeParameters != declaredParameters) {
                return Argument.ofTypeVariable(argument.getType(), argument.getName(), gp.getVariableName(), gp.getAnnotationMetadata(), typeParameters);
            }
        } else if (typeParameters != declaredParameters) {
            return Argument.of(argument.getType(), argument.getName(), argument.getAnnotationMetadata(), typeParameters);
        }
        return argument;
    }

    private Argument<?>[] resolveParameters(Map<String, Argument<?>> bounds, Argument[] typeParameters) {
        if (ArrayUtils.isEmpty(typeParameters)) {
            return typeParameters;
        }
        Argument[] resolvedParameters = new Argument[typeParameters.length];
        boolean differ = false;
        for (int i = 0; i < typeParameters.length; ++i) {
            Argument typeParameter = typeParameters[i];
            Argument resolved = this.resolveArgument(typeParameter, bounds);
            if (resolved != typeParameter) {
                resolvedParameters[i] = resolved;
                differ = true;
                continue;
            }
            resolvedParameters[i] = typeParameter;
        }
        return differ ? resolvedParameters : typeParameters;
    }

    @NonNull
    protected Map<String, Argument<?>> getBounds() {
        return Collections.emptyMap();
    }

    private String resolveName(AnnotatedElement annotatedElement, AnnotationMetadata annotationMetadata, PropertyNamingStrategy namingStrategy) {
        if (namingStrategy != null) {
            return namingStrategy.translate(annotatedElement);
        }
        return annotationMetadata.stringValue(SerdeConfig.class, "property").orElseGet(() -> annotationMetadata.stringValue(JK_PROP).orElseGet(annotatedElement::getName));
    }

    private static <T> Deserializer<T> findDeserializer(Deserializer.DecoderContext decoderContext, Argument<T> argument) throws SerdeException {
        Class customDeser = argument.getAnnotationMetadata().classValue(SerdeConfig.class, "deserializerClass").orElse(null);
        if (customDeser != null) {
            return decoderContext.findCustomDeserializer(customDeser).createSpecific(decoderContext, argument);
        }
        return decoderContext.findDeserializer(argument).createSpecific(decoderContext, argument);
    }

    private static <B, P> AnnotationMetadata resolveArgumentMetadata(BeanIntrospection<B> instrospection, Argument<P> argument, AnnotationMetadata annotationMetadata) {
        AnnotationMetadata propertyMetadata = instrospection.getProperty(argument.getName(), argument.getType()).map(AnnotationMetadataProvider::getAnnotationMetadata).orElse(AnnotationMetadata.EMPTY_METADATA);
        return new AnnotationMetadataHierarchy(propertyMetadata, annotationMetadata);
    }

    static final class AnySetter<T> {
        final Argument<T> valueType;
        private final BiConsumer<Object, Map<String, ? extends T>> mapSetter;
        private final TriConsumer<Object, T> valueSetter;
        public Deserializer<? extends T> deserializer;

        private AnySetter(BeanMethod<? super Object, Object> anySetter) {
            Argument<?>[] arguments = anySetter.getArguments();
            boolean singleArg = arguments.length == 1;
            Argument<?> argument = singleArg ? arguments[0].getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT) : arguments[1];
            this.valueType = argument;
            if (singleArg) {
                this.valueSetter = null;
                this.mapSetter = (x$0, xva$1) -> anySetter.invoke(x$0, xva$1);
            } else {
                this.valueSetter = (x$0, xva$1, xva$2) -> anySetter.invoke(x$0, xva$1, xva$2);
                this.mapSetter = null;
            }
        }

        private AnySetter(BeanProperty<? super Object, Object> anySetter) {
            Argument<Object> argument = anySetter.asArgument().getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT);
            this.valueType = argument;
            this.mapSetter = anySetter::set;
            this.valueSetter = null;
        }

        private AnySetter(Argument<Object> anySetter, int index) throws SerdeException {
            Argument<Object> argument = anySetter.getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT);
            this.valueType = argument;
            this.mapSetter = (o, map) -> {
                ((Object[])o)[index] = map;
            };
            this.valueSetter = null;
        }

        void bind(Map<String, T> values, Object object) {
            if (values != null) {
                if (this.mapSetter != null) {
                    this.mapSetter.accept(object, values);
                } else if (this.valueSetter != null) {
                    for (String s : values.keySet()) {
                        this.valueSetter.accept(object, s, values.get(s));
                    }
                }
            }
        }
    }

    @Internal
    public static final class DerProperty<B, P> {
        public final BeanIntrospection<B> instrospection;
        public final int index;
        public final Argument<P> argument;
        @Nullable
        public final P defaultValue;
        public final boolean mustSetField;
        public final boolean explicitlyRequired;
        public final boolean nonNull;
        public final boolean nullable;
        public final boolean isAnySetter;
        @Nullable
        public final Class<?>[] views;
        @Nullable
        public final String[] aliases;
        @Nullable
        public final UnsafeBeanProperty<B, P> beanProperty;
        public final DeserBean<P> unwrapped;
        public final String managedRef;
        public final String backRef;
        public Deserializer<P> deserializer;

        public DerProperty(ConversionService conversionService, BeanIntrospection<B> introspection, int index, String property, Argument<P> argument, @Nullable BeanProperty<B, P> beanProperty, @Nullable BeanMethod<B, P> beanMethod, @Nullable DeserBean<P> unwrapped) throws SerdeException {
            this(conversionService, introspection, index, property, argument, argument.getAnnotationMetadata(), beanProperty, beanMethod, unwrapped);
        }

        public DerProperty(ConversionService conversionService, BeanIntrospection<B> instrospection, int index, String property, Argument<P> argument, AnnotationMetadata argumentMetadata, @Nullable BeanProperty<B, P> beanProperty, @Nullable BeanMethod<B, P> beanMethod, @Nullable DeserBean<P> unwrapped) throws SerdeException {
            this.instrospection = instrospection;
            this.index = index;
            this.argument = argument;
            this.mustSetField = argument.isNonNull() || argument.isAssignableFrom(Optional.class) || argument.isAssignableFrom(OptionalLong.class) || argument.isAssignableFrom(OptionalDouble.class) || argument.isAssignableFrom(OptionalInt.class);
            this.nonNull = argument.isNonNull();
            this.nullable = argument.isNullable();
            this.beanProperty = beanProperty != null ? (UnsafeBeanProperty)beanProperty : (beanMethod != null ? new BeanMethodAsBeanProperty<B, P>(property, beanMethod) : null);
            AnnotationMetadata annotationMetadata = DeserBean.resolveArgumentMetadata(instrospection, argument, argumentMetadata);
            this.views = SerdeAnnotationUtil.resolveViews(instrospection, annotationMetadata);
            try {
                this.defaultValue = annotationMetadata.stringValue(Bindable.class, "defaultValue").map(s -> conversionService.convertRequired(s, argument)).orElse(null);
            }
            catch (ConversionErrorException e) {
                throw new SerdeException((index > -1 ? "Constructor Argument" : "Property") + " [" + argument + "] of type [" + instrospection.getBeanType().getName() + "] defines an invalid default value", e);
            }
            this.unwrapped = unwrapped;
            this.isAnySetter = annotationMetadata.isAnnotationPresent(SerdeConfig.SerAnySetter.class);
            Object[] aliases = annotationMetadata.stringValues(SerdeConfig.class, "aliases");
            this.aliases = ArrayUtils.isNotEmpty(aliases) ? ArrayUtils.concat(aliases, property) : null;
            this.managedRef = annotationMetadata.stringValue(SerdeConfig.SerManagedRef.class).orElse(null);
            this.backRef = annotationMetadata.stringValue(SerdeConfig.SerBackRef.class).orElse(null);
            this.explicitlyRequired = annotationMetadata.booleanValue(SerdeConfig.class, "required").orElse(false);
        }

        public void setDefaultPropertyValue(Deserializer.DecoderContext decoderContext, @NonNull B bean) throws SerdeException {
            if (!this.explicitlyRequired) {
                P def = this.defaultValue;
                if (def == null) {
                    if (!this.mustSetField) {
                        return;
                    }
                    def = this.deserializer.getDefaultValue(decoderContext, this.argument);
                }
                if (def != null && this.beanProperty != null) {
                    this.beanProperty.setUnsafe(bean, def);
                    return;
                }
            }
            throw new SerdeException("Unable to deserialize type [" + this.instrospection.getBeanType().getName() + "]. Required property [" + this.argument + "] is not present in supplied data");
        }

        public void setDefaultConstructorValue(Deserializer.DecoderContext decoderContext, @NonNull Object[] params) throws SerdeException {
            if (!this.explicitlyRequired) {
                if (this.defaultValue != null) {
                    params[this.index] = this.defaultValue;
                    return;
                }
                if (!this.mustSetField && !this.argument.isPrimitive()) {
                    return;
                }
                P newDefaultValue = this.deserializer.getDefaultValue(decoderContext, this.argument);
                if (newDefaultValue != null) {
                    params[this.index] = newDefaultValue;
                    return;
                }
            }
            throw new SerdeException("Unable to deserialize type [" + this.instrospection.getBeanType().getName() + "]. Required constructor parameter [" + this.argument + "] at index [" + this.index + "] is not present or is null in the supplied data");
        }

        public void set(@NonNull B obj, @Nullable P v) throws SerdeException {
            if (v == null && this.nonNull) {
                throw new SerdeException("Unable to deserialize type [" + this.instrospection.getBeanType().getName() + "]. Required property [" + this.argument + "] is not present in supplied data");
            }
            if (this.beanProperty != null) {
                this.beanProperty.setUnsafe(obj, v);
            }
        }

        public void deserializeAndSetConstructorValue(Decoder objectDecoder, Deserializer.DecoderContext decoderContext, Object[] values) throws IOException {
            try {
                P value = this.deserializer.deserializeNullable(objectDecoder, decoderContext, this.argument);
                if (value == null && !this.nullable) {
                    if (!this.explicitlyRequired) {
                        value = this.defaultValue;
                        if (value == null) {
                            if (!this.mustSetField) {
                                return;
                            }
                            value = this.deserializer.getDefaultValue(decoderContext, this.argument);
                        }
                    } else {
                        throw new SerdeException("Unable to deserialize type [" + this.instrospection.getBeanType().getName() + "]. Required property [" + this.argument + "] is not present in supplied data");
                    }
                }
                values[this.index] = value;
            }
            catch (InvalidFormatException e) {
                throw new InvalidPropertyFormatException(e, this.argument);
            }
            catch (Exception e) {
                throw new SerdeException("Error decoding property [" + this.argument + "] of type [" + this.instrospection.getBeanType() + "]: " + e.getMessage(), e);
            }
        }

        @Nullable
        public void deserializeAndSetPropertyValue(Decoder objectDecoder, Deserializer.DecoderContext decoderContext, B beanInstance) throws IOException {
            try {
                P value = this.deserializer.deserializeNullable(objectDecoder, decoderContext, this.argument);
                if (value == null && !this.nullable) {
                    if (!this.explicitlyRequired) {
                        value = this.defaultValue;
                        if (value == null) {
                            if (!this.mustSetField) {
                                return;
                            }
                            value = this.deserializer.getDefaultValue(decoderContext, this.argument);
                        }
                    } else {
                        throw new SerdeException("Unable to deserialize type [" + this.instrospection.getBeanType().getName() + "]. Required property [" + this.argument + "] is not present in supplied data");
                    }
                }
                this.beanProperty.setUnsafe(beanInstance, value);
            }
            catch (InvalidFormatException e) {
                throw new InvalidPropertyFormatException(e, this.argument);
            }
            catch (Exception e) {
                throw new SerdeException("Error decoding property [" + this.argument + "] of type [" + this.instrospection.getBeanType() + "]: " + e.getMessage(), e);
            }
        }
    }

    private static final class BeanMethodAsBeanProperty<B, P>
    implements UnsafeBeanProperty<B, P> {
        private final String name;
        private final BeanMethod<B, P> beanMethod;
        private final Argument<P> argument;
        private final Class<P> type;

        public BeanMethodAsBeanProperty(String name, BeanMethod<B, P> beanMethod) {
            this.name = name;
            this.beanMethod = beanMethod;
            this.argument = beanMethod.getArguments()[0];
            this.type = this.argument.getType();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public P getUnsafe(B bean) {
            throw new IllegalStateException("Not supported");
        }

        @Override
        public B withValueUnsafe(B bean, P value) {
            throw new IllegalStateException("Not supported");
        }

        @Override
        public void setUnsafe(B bean, P value) {
            this.beanMethod.invoke(bean, value);
        }

        @Override
        public BeanIntrospection<B> getDeclaringBean() {
            return null;
        }

        @Override
        public P get(B bean) {
            throw new IllegalStateException("Not supported");
        }

        @Override
        public Class<P> getType() {
            return this.type;
        }

        @Override
        public Argument<P> asArgument() {
            return this.argument;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public AnnotationMetadata getAnnotationMetadata() {
            return this.beanMethod.getAnnotationMetadata();
        }
    }

    private static interface TriConsumer<T, V> {
        public void accept(T var1, String var2, V var3);
    }
}

