/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import java.io.IOException;

final class StringArraySerializer
implements Serializer<String[]> {
    static final StringArraySerializer INSTANCE = new StringArraySerializer();

    StringArraySerializer() {
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends String[]> type, String[] strings) throws IOException {
        Encoder arrayEncoder = encoder.encodeArray(type);
        for (String string : strings) {
            arrayEncoder.encodeString(string);
        }
        arrayEncoder.finishStructure();
    }

    @Override
    public boolean isEmpty(Serializer.EncoderContext context, String[] strings) {
        return strings == null || strings.length == 0;
    }
}

