/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serializers.SerBean;
import java.io.IOException;

@Internal
public final class SimpleObjectSerializer<T>
implements Serializer<T> {
    private final SerBean<Object> serBean;

    public SimpleObjectSerializer(SerBean<Object> serBean) {
        this.serBean = serBean;
    }

    @Override
    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        try {
            if (value == null) {
                encoder.encodeNull();
            } else {
                Encoder childEncoder = encoder.encodeObject(type);
                for (SerBean.SerProperty property : this.serBean.writeProperties) {
                    childEncoder.encodeKey(property.name);
                    Object v = property.get(value);
                    if (v == null) {
                        childEncoder.encodeNull();
                        continue;
                    }
                    property.serializer.serialize(childEncoder, context, property.argument, v);
                }
                childEncoder.finishStructure();
            }
        }
        catch (StackOverflowError e) {
            throw new SerdeException("Infinite recursion serializing type: " + type.getType().getSimpleName() + " at path " + encoder.currentPath(), e);
        }
        catch (IntrospectionException e) {
            throw new SerdeException("Error serializing value at path: " + encoder.currentPath() + ". No serializer found for type: " + type, e);
        }
    }
}

