/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.core;

import io.micronaut.context.env.PropertyExpressionResolver;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.value.PropertyResolver;
import java.util.Optional;

public class LazyTestResourcesExpressionResolver
implements PropertyExpressionResolver,
AutoCloseable {
    public static final String PLACEHOLDER_PREFIX = "auto.test.resources.";
    private final PropertyExpressionResolver delegate;

    public LazyTestResourcesExpressionResolver(PropertyExpressionResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> Optional<T> resolve(PropertyResolver propertyResolver, ConversionService conversionService, String expression, Class<T> requiredType) {
        if (expression.startsWith(PLACEHOLDER_PREFIX)) {
            String eagerExpression = expression.substring(PLACEHOLDER_PREFIX.length());
            return this.delegate.resolve(propertyResolver, conversionService, eagerExpression, requiredType);
        }
        return Optional.empty();
    }

    @Override
    public void close() throws Exception {
        if (this.delegate instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.delegate)).close();
        }
    }
}

