/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.output;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;

public class Slf4jLogConsumer
extends BaseConsumer<Slf4jLogConsumer> {
    private final Logger logger;
    private final Map<String, String> mdc = new HashMap<String, String>();
    private boolean separateOutputStreams;
    private String prefix = "";

    public Slf4jLogConsumer(Logger logger) {
        this(logger, false);
    }

    public Slf4jLogConsumer(Logger logger, boolean separateOutputStreams) {
        this.logger = logger;
        this.separateOutputStreams = separateOutputStreams;
    }

    public Slf4jLogConsumer withPrefix(String prefix) {
        this.prefix = "[" + prefix + "] ";
        return this;
    }

    public Slf4jLogConsumer withMdc(String key, String value) {
        this.mdc.put(key, value);
        return this;
    }

    public Slf4jLogConsumer withMdc(Map<String, String> mdc) {
        this.mdc.putAll(mdc);
        return this;
    }

    public Slf4jLogConsumer withSeparateOutputStreams() {
        this.separateOutputStreams = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void accept(OutputFrame outputFrame) {
        OutputFrame.OutputType outputType = outputFrame.getType();
        String utf8String = outputFrame.getUtf8StringWithoutLineEnding();
        Map<String, String> originalMdc = MDC.getCopyOfContextMap();
        MDC.setContextMap(this.mdc);
        try {
            switch (outputType) {
                case END: {
                    return;
                }
                case STDOUT: {
                    if (this.separateOutputStreams) {
                        this.logger.info("{}{}", (Object)(this.prefix.isEmpty() ? "" : this.prefix + ": "), (Object)utf8String);
                        return;
                    } else {
                        this.logger.info("{}{}: {}", new Object[]{this.prefix, outputType, utf8String});
                        return;
                    }
                }
                case STDERR: {
                    if (this.separateOutputStreams) {
                        this.logger.error("{}{}", (Object)(this.prefix.isEmpty() ? "" : this.prefix + ": "), (Object)utf8String);
                        return;
                    } else {
                        this.logger.info("{}{}: {}", new Object[]{this.prefix, outputType, utf8String});
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unexpected outputType " + (Object)((Object)outputType));
                }
            }
        }
        finally {
            if (originalMdc == null) {
                MDC.clear();
            } else {
                MDC.setContextMap(originalMdc);
            }
        }
    }
}

