/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.internal.intercepted;

import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.Interceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.aop.kotlin.KotlinInterceptedMethod;
import io.micronaut.aop.util.CompletableFutureContinuation;
import io.micronaut.aop.util.DelegatingContextContinuation;
import io.micronaut.aop.util.KotlinInterceptedMethodHelper;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.KotlinUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;

@Internal
final class KotlinInterceptedMethodImpl
implements KotlinInterceptedMethod {
    private final MethodInvocationContext<?, ?> context;
    private Continuation<?> continuation;
    private final Consumer<Object> replaceContinuation;
    private final Argument<?> returnTypeValue;
    private final boolean isUnitValueType;

    private KotlinInterceptedMethodImpl(MethodInvocationContext<?, ?> context, Continuation<?> continuation, Consumer<Object> replaceContinuation, Argument<?> returnTypeValue, boolean isUnitValueType) {
        this.context = context;
        this.continuation = continuation;
        this.returnTypeValue = returnTypeValue;
        this.isUnitValueType = isUnitValueType;
        this.replaceContinuation = replaceContinuation;
    }

    public static KotlinInterceptedMethodImpl of(MethodInvocationContext<?, ?> context) {
        if (!KotlinUtils.KOTLIN_COROUTINES_SUPPORTED || !context.getExecutableMethod().isSuspend()) {
            return null;
        }
        Object[] parameterValues = context.getParameterValues();
        if (parameterValues.length == 0) {
            return null;
        }
        int lastParameterIndex = parameterValues.length - 1;
        Object lastArgumentValue = parameterValues[lastParameterIndex];
        if (lastArgumentValue instanceof Continuation) {
            boolean isUnitValueType;
            Continuation continuation = (Continuation)lastArgumentValue;
            Consumer<Object> replaceContinuation = value -> {
                parameterValues[lastParameterIndex] = value;
            };
            Argument<Object> returnTypeValue = context.getArguments()[lastParameterIndex].getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            boolean bl = isUnitValueType = returnTypeValue.getType() == Unit.class;
            if (isUnitValueType) {
                returnTypeValue = Argument.VOID_OBJECT;
            }
            return new KotlinInterceptedMethodImpl(context, continuation, replaceContinuation, returnTypeValue, isUnitValueType);
        }
        return null;
    }

    @Override
    public InterceptedMethod.ResultType resultType() {
        return InterceptedMethod.ResultType.COMPLETION_STAGE;
    }

    @Override
    public Argument<?> returnTypeValue() {
        return this.returnTypeValue;
    }

    public CompletableFuture<Object> interceptResultAsCompletionStage() {
        CompletableFutureContinuation completableFutureContinuation = new CompletableFutureContinuation(this.continuation);
        this.replaceContinuation.accept(completableFutureContinuation);
        Object result = this.context.proceed();
        this.replaceContinuation.accept(this.continuation);
        if (result != KotlinUtils.COROUTINE_SUSPENDED) {
            completableFutureContinuation.resumeWith(result);
        }
        return completableFutureContinuation.getCompletableFuture();
    }

    public CompletableFuture<Object> interceptResultAsCompletionStage(Interceptor<?, ?> from) {
        CompletableFutureContinuation completableFutureContinuation = new CompletableFutureContinuation(this.continuation);
        this.replaceContinuation.accept(completableFutureContinuation);
        Object result = this.context.proceed(from);
        this.replaceContinuation.accept(this.continuation);
        if (result != KotlinUtils.COROUTINE_SUSPENDED) {
            completableFutureContinuation.resumeWith(result);
        }
        return completableFutureContinuation.getCompletableFuture();
    }

    @Override
    public Object interceptResult() {
        return this.interceptResultAsCompletionStage();
    }

    @Override
    public Object interceptResult(Interceptor<?, ?> from) {
        return this.interceptResultAsCompletionStage((Interceptor)from);
    }

    @Override
    public Object handleResult(Object result) {
        if (!(result instanceof CompletionStage)) {
            throw new IllegalStateException("Cannot convert " + result + "  to 'java.util.concurrent.CompletionStage'");
        }
        CompletionStage completionStageResult = (CompletionStage)result;
        return KotlinInterceptedMethodHelper.handleResult(completionStageResult, this.isUnitValueType, this.continuation);
    }

    @Override
    public <E extends Throwable> Object handleException(Exception exception) throws E {
        throw exception;
    }

    @Override
    public CoroutineContext getCoroutineContext() {
        return this.continuation.getContext();
    }

    @Override
    public void updateCoroutineContext(CoroutineContext coroutineContext) {
        this.continuation = new DelegatingContextContinuation(this.continuation, coroutineContext);
    }
}

