/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.env.ActiveEnvironment;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.util.Toggleable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertySourceLoader
implements PropertySourceLoader,
Toggleable,
Ordered {
    public static final int DEFAULT_POSITION = -300;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPropertySourceLoader.class);

    @Override
    public int getOrder() {
        return -300;
    }

    @Override
    public Optional<PropertySource> load(String resourceName, ResourceLoader resourceLoader) {
        return this.load(resourceLoader, resourceName, this.getOrder());
    }

    @Override
    public Optional<PropertySource> loadEnv(String resourceName, ResourceLoader resourceLoader, ActiveEnvironment activeEnvironment) {
        return this.load(resourceLoader, resourceName + "-" + activeEnvironment.getName(), this.getOrder() + 1 + activeEnvironment.getPriority());
    }

    private Optional<PropertySource> load(ResourceLoader resourceLoader, String fileName, int order) {
        if (this.isEnabled()) {
            Set<String> extensions = this.getExtensions();
            for (String ext : extensions) {
                String fileExt = fileName + "." + ext;
                Map<String, Object> finalMap = this.loadProperties(resourceLoader, fileName, fileExt);
                if (finalMap.isEmpty()) continue;
                return Optional.of(this.createPropertySource(fileName, finalMap, order));
            }
        }
        return Optional.empty();
    }

    protected MapPropertySource createPropertySource(String name, Map<String, Object> map, final int order) {
        return new MapPropertySource(name, map){

            @Override
            public int getOrder() {
                return order;
            }
        };
    }

    private Map<String, Object> loadProperties(ResourceLoader resourceLoader, String qualifiedName, String fileName) {
        Optional<InputStream> config = this.readInput(resourceLoader, fileName);
        if (config.isPresent()) {
            Map<String, Object> map;
            block11: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found PropertySource for file name: " + fileName);
                }
                InputStream input = config.get();
                try {
                    map = this.read(qualifiedName, input);
                    if (input == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ConfigurationException("I/O exception occurred reading [" + fileName + "]: " + e.getMessage(), e);
                    }
                }
                input.close();
            }
            return map;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No PropertySource found for file name: " + fileName);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> read(String name, InputStream input) throws IOException {
        LinkedHashMap<String, Object> finalMap = new LinkedHashMap<String, Object>();
        this.processInput(name, input, finalMap);
        return finalMap;
    }

    protected Optional<InputStream> readInput(ResourceLoader resourceLoader, String fileName) {
        return resourceLoader.getResourceAsStream(fileName);
    }

    protected abstract void processInput(String var1, InputStream var2, Map<String, Object> var3) throws IOException;

    protected void processMap(Map<String, Object> finalMap, Map map, String prefix) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map && !((Map)value).isEmpty()) {
                this.processMap(finalMap, (Map)value, prefix + key + ".");
                continue;
            }
            finalMap.put(prefix + key, value);
        }
    }
}

