/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanConstructor;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Internal
public abstract class AbstractBeanIntrospection<T>
implements BeanIntrospection<T> {
    protected final AnnotationMetadata annotationMetadata;
    protected final Class<T> beanType;
    protected final Map<String, BeanProperty<T, Object>> beanProperties;
    protected final List<BeanMethod<T, Object>> beanMethods;
    private Map<Class<? extends Annotation>, List<BeanProperty<T, Object>>> indexed;
    private Map<AnnotationValueKey, BeanProperty<T, Object>> indexedValues;

    protected AbstractBeanIntrospection(@NonNull Class<T> beanType, @Nullable AnnotationMetadata annotationMetadata, int propertyCount) {
        this(beanType, annotationMetadata, propertyCount, 0);
    }

    protected AbstractBeanIntrospection(@NonNull Class<T> beanType, @Nullable AnnotationMetadata annotationMetadata, int propertyCount, int methodCount) {
        ArgumentUtils.requireNonNull("beanType", beanType);
        this.beanType = beanType;
        this.annotationMetadata = annotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : annotationMetadata;
        this.beanProperties = new LinkedHashMap<String, BeanProperty<T, Object>>(propertyCount);
        this.beanMethods = methodCount == 0 ? Collections.emptyList() : new ArrayList(methodCount);
    }

    @Override
    public BeanConstructor<T> getConstructor() {
        return new BeanConstructor<T>(){

            @Override
            public Class<T> getDeclaringBeanType() {
                return AbstractBeanIntrospection.this.getBeanType();
            }

            @Override
            public Argument<?>[] getArguments() {
                return AbstractBeanIntrospection.this.getConstructorArguments();
            }

            @Override
            public T instantiate(Object ... parameterValues) {
                return AbstractBeanIntrospection.this.instantiate(parameterValues);
            }

            @Override
            public AnnotationMetadata getAnnotationMetadata() {
                return AbstractBeanIntrospection.this.getConstructorAnnotationMetadata();
            }
        };
    }

    protected AnnotationMetadata getConstructorAnnotationMetadata() {
        return AnnotationMetadata.EMPTY_METADATA;
    }

    @Override
    @NonNull
    public Optional<BeanProperty<T, Object>> getIndexedProperty(@NonNull Class<? extends Annotation> annotationType, @NonNull String annotationValue) {
        ArgumentUtils.requireNonNull("annotationType", annotationType);
        if (this.indexedValues != null && StringUtils.isNotEmpty(annotationValue)) {
            return Optional.ofNullable(this.indexedValues.get(new AnnotationValueKey(annotationType, annotationValue)));
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public T instantiate(boolean strictNullable, Object ... arguments) throws InstantiationException {
        ArgumentUtils.requireNonNull("arguments", arguments);
        if (arguments.length == 0) {
            return this.instantiate();
        }
        Argument<?>[] constructorArguments = this.getConstructorArguments();
        if (constructorArguments.length != arguments.length) {
            throw new InstantiationException("Argument count [" + arguments.length + "] doesn't match required argument count: " + constructorArguments.length);
        }
        for (int i = 0; i < constructorArguments.length; ++i) {
            Argument<?> constructorArgument = constructorArguments[i];
            Object specified = arguments[i];
            if (specified == null) {
                if (constructorArgument.isDeclaredNullable() || !strictNullable) continue;
                throw new InstantiationException("Null argument specified for [" + constructorArgument.getName() + "]. If this argument is allowed to be null annotate it with @Nullable");
            }
            if (ReflectionUtils.getWrapperType(constructorArgument.getType()).isInstance(specified)) continue;
            throw new InstantiationException("Invalid argument [" + specified + "] specified for argument: " + constructorArgument);
        }
        return this.instantiateInternal(arguments);
    }

    @Override
    @NonNull
    public Optional<BeanProperty<T, Object>> getProperty(@NonNull String name) {
        ArgumentUtils.requireNonNull("name", name);
        return Optional.ofNullable(this.beanProperties.get(name));
    }

    @Override
    public int propertyIndexOf(String name) {
        return new ArrayList<String>(this.beanProperties.keySet()).indexOf(name);
    }

    @Override
    @NonNull
    public Collection<BeanProperty<T, Object>> getIndexedProperties(@NonNull Class<? extends Annotation> annotationType) {
        List<BeanProperty<T, Object>> indexed;
        ArgumentUtils.requireNonNull("annotationType", annotationType);
        if (this.indexed != null && (indexed = this.indexed.get(annotationType)) != null) {
            return Collections.unmodifiableCollection(indexed);
        }
        return Collections.emptyList();
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    @NonNull
    public Collection<BeanProperty<T, Object>> getBeanProperties() {
        return Collections.unmodifiableCollection(this.beanProperties.values());
    }

    @Override
    @NonNull
    public Class<T> getBeanType() {
        return this.beanType;
    }

    @Internal
    protected abstract T instantiateInternal(Object[] var1);

    @Internal
    protected final void addProperty(@NonNull BeanProperty<T, Object> property) {
        ArgumentUtils.requireNonNull("property", property);
        this.beanProperties.put(property.getName(), property);
    }

    @Internal
    protected final void addMethod(@NonNull BeanMethod<T, Object> method) {
        ArgumentUtils.requireNonNull("method", method);
        this.beanMethods.add(method);
    }

    @Override
    @NonNull
    public Collection<BeanMethod<T, Object>> getBeanMethods() {
        return Collections.unmodifiableCollection(this.beanMethods);
    }

    @Internal
    protected final void indexProperty(@NonNull Class<? extends Annotation> annotationType, @NonNull String propertyName) {
        ArgumentUtils.requireNonNull("annotationType", annotationType);
        if (StringUtils.isNotEmpty(propertyName)) {
            BeanProperty<T, Object> property = this.beanProperties.get(propertyName);
            if (property == null) {
                throw new IllegalStateException("Invalid byte code generated during bean introspection. Call addProperty first!");
            }
            if (this.indexed == null) {
                this.indexed = new HashMap<Class<? extends Annotation>, List<BeanProperty<T, Object>>>(2);
            }
            List indexed = this.indexed.computeIfAbsent(annotationType, aClass -> new ArrayList(2));
            indexed.add(property);
        }
    }

    @Internal
    protected final void indexProperty(@NonNull Class<? extends Annotation> annotationType, @NonNull String propertyName, @Nullable String annotationValue) {
        this.indexProperty(annotationType, propertyName);
        if (StringUtils.isNotEmpty(annotationValue) && StringUtils.isNotEmpty(propertyName)) {
            if (this.indexedValues == null) {
                this.indexedValues = new HashMap<AnnotationValueKey, BeanProperty<T, Object>>(10);
            }
            BeanProperty<T, Object> property = this.beanProperties.get(propertyName);
            this.indexedValues.put(new AnnotationValueKey(annotationType, annotationValue), property);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBeanIntrospection that = (AbstractBeanIntrospection)o;
        return Objects.equals(this.beanType, that.beanType);
    }

    public int hashCode() {
        return this.beanType.hashCode();
    }

    public String toString() {
        return "BeanIntrospection{type=" + this.beanType + "}";
    }

    private final class AnnotationValueKey {
        @NonNull
        final Class<? extends Annotation> type;
        @NonNull
        final String value;

        AnnotationValueKey(@NonNull Class<? extends Annotation> type, String value) {
            this.type = type;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationValueKey that = (AnnotationValueKey)o;
            return this.type.equals(that.type) && this.value.equals(that.value);
        }

        public int hashCode() {
            return ObjectUtils.hash(this.type, this.value);
        }
    }
}

