/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.attr.MutableAttributeHolder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.util.HttpUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;

public interface HttpMessage<B>
extends MutableAttributeHolder {
    @NonNull
    public HttpHeaders getHeaders();

    @Override
    @NonNull
    public MutableConvertibleValues<Object> getAttributes();

    @NonNull
    public Optional<B> getBody();

    @NonNull
    default public Charset getCharacterEncoding() {
        return HttpUtil.resolveCharset(this).orElse(StandardCharsets.UTF_8);
    }

    @Override
    @NonNull
    default public HttpMessage<B> setAttribute(@NonNull CharSequence name, Object value) {
        return (HttpMessage)MutableAttributeHolder.super.setAttribute(name, value);
    }

    @NonNull
    default public <T> Optional<T> getBody(@NonNull Argument<T> type) {
        return this.getBody(ConversionContext.of(type));
    }

    @NonNull
    default public <T> Optional<T> getBody(@NonNull ArgumentConversionContext<T> conversionContext) {
        ArgumentUtils.requireNonNull("conversionContext", conversionContext);
        return this.getBody().flatMap(b -> ConversionService.SHARED.convert(b, conversionContext));
    }

    @NonNull
    default public <T> Optional<T> getBody(@NonNull Class<T> type) {
        ArgumentUtils.requireNonNull("type", type);
        return this.getBody(Argument.of(type));
    }

    @NonNull
    default public Optional<Locale> getLocale() {
        return this.getHeaders().findFirst("Content-Language").map(Locale::new);
    }

    default public long getContentLength() {
        return this.getHeaders().contentLength().orElse(-1L);
    }

    @NonNull
    default public Optional<MediaType> getContentType() {
        return this.getHeaders().contentType();
    }
}

