/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.AbstractArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.binders.BodyArgumentBinder;
import io.micronaut.http.bind.binders.PostponedRequestArgumentBinder;
import java.util.Optional;

public class DefaultBodyAnnotationBinder<T>
extends AbstractArgumentBinder<T>
implements BodyArgumentBinder<T>,
PostponedRequestArgumentBinder<T> {
    protected final ConversionService conversionService;

    public DefaultBodyAnnotationBinder(ConversionService conversionService) {
        super(conversionService);
        this.conversionService = conversionService;
    }

    @Override
    public Class<Body> getAnnotationType() {
        return Body.class;
    }

    @Override
    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        ArgumentBinder.BindingResult<T> convertibleValuesBindingResult;
        Optional<ConvertibleValues> convertibleValuesBody;
        if (!source.getMethod().permitsRequestBody()) {
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        Optional body = source.getBody();
        if (body.isEmpty()) {
            return ArgumentBinder.BindingResult.empty();
        }
        boolean annotatedAsBody = context.getAnnotationMetadata().hasAnnotation(Body.class);
        Optional<String> optionalBodyComponent = context.getAnnotationMetadata().stringValue(Body.class);
        String bodyComponent = optionalBodyComponent.orElseGet(() -> {
            if (annotatedAsBody) {
                return null;
            }
            return context.getArgument().getName();
        });
        if (bodyComponent != null && (convertibleValuesBody = source.getBody(ConvertibleValues.class)).isPresent() && ((convertibleValuesBindingResult = this.doBind(context, convertibleValuesBody.get(), bodyComponent)).getValue().isPresent() || !convertibleValuesBindingResult.getConversionErrors().isEmpty())) {
            return convertibleValuesBindingResult;
        }
        ArgumentBinder.BindingResult<T> bindingResult = this.doConvert(body.get(), context);
        if (!annotatedAsBody && bindingResult.getValue().isEmpty()) {
            return ArgumentBinder.BindingResult.empty();
        }
        return bindingResult;
    }
}

