/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.util.ReferenceCountUtil;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;

@Internal
public class DefaultHttpContentProcessor
implements HttpContentProcessor {
    protected final NettyHttpRequest<?> nettyHttpRequest;
    protected final ChannelHandlerContext ctx;
    protected final HttpServerConfiguration configuration;
    protected final long advertisedLength;
    protected final long requestMaxSize;
    protected final AtomicLong receivedLength = new AtomicLong();

    public DefaultHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, HttpServerConfiguration configuration) {
        this.nettyHttpRequest = nettyHttpRequest;
        this.configuration = configuration;
        this.requestMaxSize = configuration.getMaxRequestSize();
        this.ctx = nettyHttpRequest.getChannelHandlerContext();
        this.advertisedLength = nettyHttpRequest.getContentLength();
    }

    @Override
    public void add(ByteBufHolder message, Collection<Object> out) {
        long receivedLength = this.receivedLength.addAndGet(this.resolveLength(message));
        if (this.advertisedLength > this.requestMaxSize) {
            this.fireExceedsLength(this.advertisedLength, this.requestMaxSize, message);
        } else if (receivedLength > this.requestMaxSize) {
            this.fireExceedsLength(receivedLength, this.requestMaxSize, message);
        } else {
            out.add(message);
        }
    }

    private long resolveLength(ByteBufHolder message) {
        if (message instanceof HttpData) {
            return ((HttpData)message).length();
        }
        return message.content().readableBytes();
    }

    private void fireExceedsLength(long receivedLength, long expected, ByteBufHolder message) {
        ReferenceCountUtil.safeRelease(message);
        throw new ContentLengthExceededException(expected, receivedLength);
    }
}

