/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.AbstractHttpContentProcessor;
import io.micronaut.http.server.netty.MicronautHttpData;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;

@Internal
public class FormDataHttpContentProcessor
extends AbstractHttpContentProcessor {
    private final InterfaceHttpPostRequestDecoder decoder;
    private final boolean enabled;
    private final long partMaxSize;
    private volatile boolean pleaseDestroy = false;
    private volatile boolean inFlight = false;
    private boolean destroyed = false;

    FormDataHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, NettyHttpServerConfiguration configuration) {
        super(nettyHttpRequest, configuration);
        Charset characterEncoding = nettyHttpRequest.getCharacterEncoding();
        HttpServerConfiguration.MultipartConfiguration multipart = configuration.getMultipart();
        MicronautHttpData.Factory factory = new MicronautHttpData.Factory(multipart, characterEncoding);
        HttpRequest nativeRequest = nettyHttpRequest.getNativeRequest();
        this.decoder = HttpPostRequestDecoder.isMultipart(nativeRequest) ? new HttpPostMultipartRequestDecoder(factory, nativeRequest, characterEncoding) : new HttpPostStandardRequestDecoder(factory, nativeRequest, characterEncoding);
        this.enabled = nettyHttpRequest.getContentType().map(type -> type.equals(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).orElse(false) != false || multipart.isEnabled();
        this.partMaxSize = multipart.getMaxFileSize();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void onData(ByteBufHolder message, Collection<Object> out) {
        block24: {
            boolean skip;
            FormDataHttpContentProcessor formDataHttpContentProcessor = this;
            synchronized (formDataHttpContentProcessor) {
                if (this.destroyed) {
                    skip = true;
                } else {
                    skip = false;
                    this.inFlight = true;
                }
            }
            if (skip) {
                message.release();
                return;
            }
            try {
                if (message instanceof HttpContent) {
                    HttpContent httpContent = (HttpContent)message;
                    try {
                        InterfaceHttpPostRequestDecoder postRequestDecoder = this.decoder;
                        postRequestDecoder.offer(httpContent);
                        block17: while (postRequestDecoder.hasNext()) {
                            InterfaceHttpData data = postRequestDecoder.next();
                            data.touch();
                            switch (data.getHttpDataType()) {
                                case Attribute: {
                                    Attribute attribute = (Attribute)data;
                                    out.add(attribute.retain());
                                    postRequestDecoder.removeHttpDataFromClean(attribute);
                                    break;
                                }
                                case FileUpload: {
                                    FileUpload fileUpload = (FileUpload)data;
                                    if (!fileUpload.isCompleted()) continue block17;
                                    out.add(fileUpload.retain());
                                    postRequestDecoder.removeHttpDataFromClean(fileUpload);
                                    break;
                                }
                            }
                        }
                        InterfaceHttpData currentPartialHttpData = postRequestDecoder.currentPartialHttpData();
                        if (currentPartialHttpData != null) {
                            out.add(currentPartialHttpData);
                            postRequestDecoder.removeHttpDataFromClean(currentPartialHttpData);
                        }
                        break block24;
                    }
                    catch (HttpPostRequestDecoder.EndOfDataDecoderException postRequestDecoder) {
                        httpContent.release();
                        break block24;
                    }
                    catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof IOException && cause.getMessage().equals("Size exceed allowed maximum capacity")) {
                            String partName = this.decoder.currentPartialHttpData().getName();
                            throw new ContentLengthExceededException("The part named [" + partName + "] exceeds the maximum allowed content length [" + this.partMaxSize + "]");
                        }
                        throw e;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        httpContent.release();
                    }
                }
                message.release();
            }
            finally {
                this.inFlight = false;
                this.destroyIfRequested();
            }
        }
    }

    @Override
    public void add(ByteBufHolder message, Collection<Object> out) throws Throwable {
        try {
            super.add(message, out);
        }
        catch (Throwable e) {
            this.cancel();
            throw e;
        }
    }

    @Override
    public void complete(Collection<Object> out) {
        this.cancel();
    }

    @Override
    public void cancel() {
        this.pleaseDestroy = true;
        this.destroyIfRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIfRequested() {
        boolean destroy;
        FormDataHttpContentProcessor formDataHttpContentProcessor = this;
        synchronized (formDataHttpContentProcessor) {
            if (this.pleaseDestroy && !this.destroyed && !this.inFlight) {
                destroy = true;
                this.destroyed = true;
            } else {
                destroy = false;
            }
        }
        if (destroy) {
            this.decoder.destroy();
        }
    }
}

