/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.PushCapableHttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpParameters;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.http.netty.cookies.NettyCookies;
import io.micronaut.http.netty.stream.DefaultStreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.FormRouteCompleter;
import io.micronaut.http.server.netty.HttpPipelineBuilder;
import io.micronaut.http.server.netty.ServerAttributeKeys;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.body.HttpBody;
import io.micronaut.http.server.netty.body.ImmediateMultiObjectBody;
import io.micronaut.http.server.netty.body.ImmediateSingleObjectBody;
import io.micronaut.http.server.netty.multipart.NettyCompletedFileUpload;
import io.micronaut.web.router.RouteMatch;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http2.DefaultHttp2PushPromiseFrame;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Attribute;
import io.netty.util.ReferenceCounted;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class NettyHttpRequest<T>
extends AbstractNettyHttpRequest<T>
implements HttpRequest<T>,
PushCapableHttpRequest<T> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpRequest.class);
    private static final io.netty.handler.codec.http.HttpHeaders SERVER_PUSH_EXCLUDE_HEADERS = new DefaultHttpHeaders();
    private final NettyHttpHeaders headers;
    private final ChannelHandlerContext channelHandlerContext;
    private final HttpServerConfiguration serverConfiguration;
    private MutableConvertibleValues<Object> attributes;
    private NettyCookies nettyCookies;
    private final ByteBody body;
    @Nullable
    private FormRouteCompleter formRouteCompleter;
    private boolean headersMutated = false;
    private final long contentLength;
    @Nullable
    private final MediaType contentType;
    @Nullable
    private final String origin;
    private final BodyConvertor bodyConvertor = this.newBodyConvertor();

    public NettyHttpRequest(io.netty.handler.codec.http.HttpRequest nettyRequest, ChannelHandlerContext ctx, ConversionService environment, HttpServerConfiguration serverConfiguration) {
        super(nettyRequest, environment);
        Objects.requireNonNull(nettyRequest, "Netty request cannot be null");
        Objects.requireNonNull(ctx, "ChannelHandlerContext cannot be null");
        Objects.requireNonNull(environment, "Environment cannot be null");
        Channel channel = ctx.channel();
        if (channel != null) {
            channel.attr(ServerAttributeKeys.REQUEST_KEY).set(this);
        }
        this.serverConfiguration = serverConfiguration;
        this.channelHandlerContext = ctx;
        this.headers = new NettyHttpHeaders(nettyRequest.headers(), this.conversionService);
        this.body = ByteBody.of(nettyRequest);
        this.contentLength = this.headers.contentLength().orElse(-1L);
        this.contentType = this.headers.contentType().orElse(null);
        this.origin = this.headers.getOrigin().orElse(null);
    }

    public final ByteBody rootBody() {
        return this.body;
    }

    private HttpBody lastBody() {
        HttpBody next;
        HttpBody body = this.rootBody();
        while ((next = body.next()) != null) {
            body = next;
        }
        return body;
    }

    public final FormRouteCompleter formRouteCompleter() {
        if (this.formRouteCompleter == null) {
            this.formRouteCompleter = new FormRouteCompleter(this, (RouteMatch)this.getAttribute(HttpAttributes.ROUTE_MATCH).get());
        }
        return this.formRouteCompleter;
    }

    @Override
    public MutableHttpRequest<T> mutate() {
        return new NettyMutableHttpRequest();
    }

    @Override
    @NonNull
    public Optional<Object> getAttribute(CharSequence name) {
        return Optional.ofNullable(this.getAttributes().getValue(Objects.requireNonNull(name, "Name cannot be null").toString()));
    }

    @Override
    public HttpVersion getHttpVersion() {
        HttpPipelineBuilder.StreamPipeline pipeline = this.channelHandlerContext.channel().attr(HttpPipelineBuilder.STREAM_PIPELINE_ATTRIBUTE.get()).get();
        if (pipeline != null) {
            return pipeline.httpVersion;
        }
        return HttpVersion.HTTP_1_1;
    }

    public String toString() {
        return this.getMethodName() + " " + this.getUri();
    }

    public io.netty.handler.codec.http.HttpRequest getNativeRequest() {
        return this.nettyRequest;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cookies getCookies() {
        NettyCookies cookies = this.nettyCookies;
        if (cookies == null) {
            NettyHttpRequest nettyHttpRequest = this;
            synchronized (nettyHttpRequest) {
                cookies = this.nettyCookies;
                if (cookies == null) {
                    this.nettyCookies = cookies = new NettyCookies(this.getPath(), this.headers.getNettyHeaders(), this.conversionService);
                }
            }
        }
        return cookies;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.getChannelHandlerContext().channel().remoteAddress();
    }

    @Override
    public InetSocketAddress getServerAddress() {
        return (InetSocketAddress)this.getChannelHandlerContext().channel().localAddress();
    }

    @Override
    public String getServerName() {
        return this.getServerAddress().getHostName();
    }

    @Override
    public boolean isSecure() {
        ChannelHandlerContext channelHandlerContext = this.getChannelHandlerContext();
        return channelHandlerContext.pipeline().get(SslHandler.class) != null;
    }

    @Override
    public Optional<String> getOrigin() {
        if (this.headersMutated) {
            return this.getHeaders().getOrigin();
        }
        return Optional.ofNullable(this.origin);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValues<Object> attributes = this.attributes;
        if (attributes == null) {
            NettyHttpRequest nettyHttpRequest = this;
            synchronized (nettyHttpRequest) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap<Object>(new HashMap(8));
                }
            }
        }
        return attributes;
    }

    @Override
    public HttpRequest<T> setAttribute(CharSequence name, Object value) {
        if (StringUtils.isNotEmpty(name)) {
            if (value == null) {
                this.getAttributes().remove(name.toString());
            } else {
                this.getAttributes().put(name.toString(), value);
            }
        }
        return this;
    }

    @Override
    public Optional<T> getBody() {
        HttpBody lastBody = this.lastBody();
        if (lastBody instanceof ImmediateMultiObjectBody) {
            ImmediateMultiObjectBody multi = (ImmediateMultiObjectBody)lastBody;
            lastBody = multi.single(this.serverConfiguration.getDefaultCharset(), this.channelHandlerContext.alloc());
        }
        if (lastBody instanceof ImmediateSingleObjectBody) {
            ImmediateSingleObjectBody single = (ImmediateSingleObjectBody)lastBody;
            return Optional.ofNullable(single.valueUnclaimed());
        }
        if (lastBody instanceof FormRouteCompleter) {
            FormRouteCompleter frc = (FormRouteCompleter)lastBody;
            return Optional.of(frc.asMap(this.serverConfiguration.getDefaultCharset()));
        }
        return Optional.empty();
    }

    @Override
    public <T1> Optional<T1> getBody(Class<T1> type) {
        return this.getBody(Argument.of(type));
    }

    @Override
    public <T1> Optional<T1> getBody(ArgumentConversionContext<T1> conversionContext) {
        return this.getBody().flatMap(t -> this.bodyConvertor.convert(conversionContext, t));
    }

    @Internal
    public void release() {
        io.netty.handler.codec.http.HttpRequest httpRequest;
        RouteMatch routeMatch = this.getAttribute(HttpAttributes.ROUTE_MATCH).orElse(null);
        if (routeMatch != null) {
            for (Object toDiscard : routeMatch.getVariableValues().values()) {
                Object rc;
                if (toDiscard instanceof io.micronaut.core.io.buffer.ReferenceCounted) {
                    rc = (io.micronaut.core.io.buffer.ReferenceCounted)toDiscard;
                    rc.release();
                }
                if (toDiscard instanceof ReferenceCounted) {
                    rc = (ReferenceCounted)toDiscard;
                    rc.release();
                }
                if (!(toDiscard instanceof NettyCompletedFileUpload)) continue;
                NettyCompletedFileUpload fu = (NettyCompletedFileUpload)toDiscard;
                fu.discard();
            }
        }
        this.body.release();
        if (this.attributes != null) {
            this.attributes.values().forEach(this::releaseIfNecessary);
        }
        if ((httpRequest = this.nettyRequest) instanceof StreamedHttpRequest) {
            StreamedHttpRequest streamedHttpRequest = (StreamedHttpRequest)httpRequest;
            streamedHttpRequest.closeIfNoSubscriber();
        }
    }

    protected void releaseIfNecessary(Object value) {
        ReferenceCounted referenceCounted;
        int i;
        if (value instanceof ReferenceCounted && (i = (referenceCounted = (ReferenceCounted)value).refCnt()) != 0) {
            referenceCounted.release();
        }
    }

    @Nullable
    private ChannelHandlerContext findConnectionHandler() {
        ChannelHandlerContext current = this.channelHandlerContext.pipeline().context(Http2ConnectionHandler.class);
        if (current != null) {
            return current;
        }
        Channel parentChannel = this.channelHandlerContext.channel().parent();
        if (parentChannel != null) {
            return parentChannel.pipeline().context(Http2FrameCodec.class);
        }
        return null;
    }

    @Override
    public boolean isServerPushSupported() {
        ChannelHandlerContext http2ConnectionHandlerContext = this.findConnectionHandler();
        return http2ConnectionHandlerContext != null && ((Http2ConnectionHandler)http2ConnectionHandlerContext.handler()).connection().remote().allowPushTo();
    }

    @Override
    public PushCapableHttpRequest<T> serverPush(@NonNull HttpRequest<?> request) {
        final ChannelHandlerContext connectionHandlerContext = this.findConnectionHandler();
        if (connectionHandlerContext != null) {
            URI fixedUri;
            String path;
            String authority;
            Http2ConnectionHandler connectionHandler = (Http2ConnectionHandler)connectionHandlerContext.handler();
            if (!connectionHandler.connection().remote().allowPushTo()) {
                throw new UnsupportedOperationException("Server push not supported by this client: Client is HTTP2 but does not report support for this feature");
            }
            URI configuredUri = request.getUri();
            String scheme = configuredUri.getScheme();
            if (scheme == null) {
                String string = scheme = this.channelHandlerContext.channel().parent().pipeline().get(SslHandler.class) == null ? "http" : "https";
            }
            if ((authority = configuredUri.getAuthority()) == null) {
                authority = (String)this.getHeaders().get("Host");
            }
            if ((path = configuredUri.getPath()) == null || !path.startsWith("/")) {
                throw new IllegalArgumentException("Request must have an absolute path");
            }
            String query = configuredUri.getQuery();
            String fragment = configuredUri.getFragment();
            try {
                fixedUri = new URI(scheme, authority, path, query, fragment);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Illegal URI", e);
            }
            final io.netty.handler.codec.http.HttpRequest inboundRequest = NettyHttpRequestBuilder.toHttpRequest(request);
            Iterator<Map.Entry<CharSequence, CharSequence>> itr = this.headers.getNettyHeaders().iteratorCharSequence();
            while (itr.hasNext()) {
                Map.Entry<CharSequence, CharSequence> entry = itr.next();
                if (inboundRequest.headers().contains(entry.getKey()) || SERVER_PUSH_EXCLUDE_HEADERS.contains(entry.getKey())) continue;
                inboundRequest.headers().add(entry.getKey(), (Object)entry.getValue());
            }
            if (!inboundRequest.headers().contains(HttpHeaderNames.REFERER)) {
                inboundRequest.headers().add((CharSequence)HttpHeaderNames.REFERER, (Object)this.getUri().toString());
            }
            final DefaultHttpRequest outboundRequest = new DefaultHttpRequest(inboundRequest.protocolVersion(), inboundRequest.method(), fixedUri.toString(), inboundRequest.headers());
            final int ourStream = ((Http2StreamChannel)this.channelHandlerContext.channel()).stream().id();
            final HttpPipelineBuilder.StreamPipeline originalStreamPipeline = this.channelHandlerContext.channel().attr(HttpPipelineBuilder.STREAM_PIPELINE_ATTRIBUTE.get()).get();
            new Http2StreamChannelBootstrap(this.channelHandlerContext.channel().parent()).handler(new ChannelInitializer<Http2StreamChannel>(){

                @Override
                protected void initChannel(@NonNull Http2StreamChannel ch) throws Exception {
                    int newStream = ch.stream().id();
                    NettyHttpRequest.this.channelHandlerContext.write(new DefaultHttp2PushPromiseFrame(HttpConversionUtil.toHttp2Headers(outboundRequest, false)).stream(((Http2StreamChannel)NettyHttpRequest.this.channelHandlerContext.channel()).stream()).pushStream(ch.stream()));
                    originalStreamPipeline.initializeChildPipelineForPushPromise(ch);
                    inboundRequest.headers().setInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), newStream);
                    inboundRequest.headers().setInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), ourStream);
                    connectionHandlerContext.executor().execute(() -> {
                        try {
                            ch.pipeline().context("http-decoder").fireChannelRead(inboundRequest);
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to complete push promise", e);
                        }
                    });
                }
            }).open().addListener(future -> {
                try {
                    future.sync();
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    LOG.warn("Failed to complete push promise", e);
                }
            });
            return this;
        }
        throw new UnsupportedOperationException("Server push not supported by this client: Not a HTTP2 client");
    }

    @Override
    protected Charset initCharset(Charset characterEncoding) {
        return characterEncoding == null ? this.serverConfiguration.getDefaultCharset() : characterEncoding;
    }

    @Internal
    public final boolean isFormOrMultipartData() {
        MediaType ct = this.getContentType().orElse(null);
        return ct != null && (ct.equals(MediaType.APPLICATION_FORM_URLENCODED_TYPE) || ct.equals(MediaType.MULTIPART_FORM_DATA_TYPE));
    }

    @Internal
    public final boolean isFormData() {
        MediaType ct = this.getContentType().orElse(null);
        return ct != null && ct.equals(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    @Override
    public Optional<MediaType> getContentType() {
        if (this.headersMutated) {
            return this.headers.contentType();
        }
        return Optional.ofNullable(this.contentType);
    }

    static NettyHttpRequest remove(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        Attribute<NettyHttpRequest> attr = channel.attr(ServerAttributeKeys.REQUEST_KEY);
        return attr.getAndSet(null);
    }

    private BodyConvertor newBodyConvertor() {
        return new BodyConvertor(){

            public Optional convert(ArgumentConversionContext conversionContext, Object value) {
                if (value == null) {
                    return Optional.empty();
                }
                if (Argument.OBJECT_ARGUMENT.equalsType(conversionContext.getArgument())) {
                    return Optional.of(value);
                }
                return this.convertFromNext(NettyHttpRequest.this.conversionService, conversionContext, value);
            }
        };
    }

    @Override
    public long getContentLength() {
        if (this.headersMutated) {
            return super.getContentLength();
        }
        return this.contentLength;
    }

    static {
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.ETAG, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_MATCH, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_NONE_MATCH, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_UNMODIFIED_SINCE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.CONTENT_RANGE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.IF_RANGE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.RANGE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.EXPECT, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.REFERER, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.PROXY_AUTHENTICATE, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.PATH.text(), (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"");
        SERVER_PUSH_EXCLUDE_HEADERS.add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), (Object)"");
    }

    private static abstract class BodyConvertor<T> {
        private BodyConvertor<T> nextConvertor;

        private BodyConvertor() {
        }

        public abstract Optional<T> convert(ArgumentConversionContext<T> var1, T var2);

        protected synchronized Optional<T> convertFromNext(final ConversionService conversionService, final ArgumentConversionContext<T> conversionContext, T value) {
            if (this.nextConvertor == null) {
                final Optional<T> conversion = conversionService.convert(value, conversionContext);
                this.nextConvertor = new BodyConvertor<T>(){

                    @Override
                    public Optional<T> convert(ArgumentConversionContext<T> currentConversionContext, T value) {
                        if (currentConversionContext == conversionContext) {
                            return conversion;
                        }
                        if (currentConversionContext.getArgument().equalsType(conversionContext.getArgument())) {
                            conversionContext.getLastError().ifPresent(error -> error.getOriginalValue().ifPresentOrElse(originalValue -> currentConversionContext.reject(originalValue, error.getCause()), () -> currentConversionContext.reject(error.getCause())));
                            return conversion;
                        }
                        return this.convertFromNext(conversionService, currentConversionContext, value);
                    }
                };
                return conversion;
            }
            return this.nextConvertor.convert(conversionContext, value);
        }

        public void cleanup() {
            this.nextConvertor = null;
        }
    }

    private class NettyMutableHttpRequest
    implements MutableHttpRequest<T>,
    NettyHttpRequestBuilder {
        private URI uri;
        @Nullable
        private MutableHttpParameters httpParameters;
        @Nullable
        private Object body;

        private NettyMutableHttpRequest() {
            this.uri = NettyHttpRequest.this.uri;
        }

        @Override
        public void setConversionService(ConversionService conversionService) {
            if (this.httpParameters != null) {
                this.httpParameters.setConversionService(conversionService);
            }
        }

        @Override
        public MutableHttpRequest<T> cookie(Cookie cookie) {
            if (cookie instanceof NettyCookie) {
                NettyCookie nettyCookie = (NettyCookie)cookie;
                String value = ClientCookieEncoder.LAX.encode(nettyCookie.getNettyCookie());
                NettyHttpRequest.this.headers.add((CharSequence)HttpHeaderNames.COOKIE, value);
            }
            return this;
        }

        @Override
        public MutableHttpRequest<T> uri(URI uri) {
            this.uri = uri;
            if (uri.getQuery() != null) {
                this.httpParameters = null;
            }
            return this;
        }

        @Override
        public <T1> MutableHttpRequest<T1> body(T1 body) {
            this.body = body;
            return this;
        }

        @Override
        public MutableHttpHeaders getHeaders() {
            NettyHttpRequest.this.headersMutated = true;
            return NettyHttpRequest.this.headers;
        }

        @Override
        @NonNull
        public MutableConvertibleValues<Object> getAttributes() {
            return NettyHttpRequest.this.getAttributes();
        }

        @Override
        @NonNull
        public Optional<T> getBody() {
            if (this.body != null) {
                return Optional.of(this.body);
            }
            return NettyHttpRequest.this.getBody();
        }

        @Override
        @NonNull
        public Cookies getCookies() {
            return NettyHttpRequest.this.getCookies();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MutableHttpParameters getParameters() {
            MutableHttpParameters httpParameters = this.httpParameters;
            if (httpParameters == null) {
                NettyMutableHttpRequest nettyMutableHttpRequest = this;
                synchronized (nettyMutableHttpRequest) {
                    httpParameters = this.httpParameters;
                    if (httpParameters == null) {
                        QueryStringDecoder queryStringDecoder = NettyHttpRequest.this.createDecoder(this.uri);
                        this.httpParameters = httpParameters = new NettyHttpParameters(queryStringDecoder.parameters(), NettyHttpRequest.this.conversionService, null);
                    }
                }
            }
            return httpParameters;
        }

        @Override
        @NonNull
        public HttpMethod getMethod() {
            return NettyHttpRequest.this.getMethod();
        }

        @Override
        @NonNull
        public URI getUri() {
            if (this.uri != null) {
                return this.uri;
            }
            return NettyHttpRequest.this.getUri();
        }

        @Override
        @NonNull
        public FullHttpRequest toFullHttpRequest() {
            io.netty.handler.codec.http.HttpRequest nr = NettyHttpRequest.this.nettyRequest;
            if (nr instanceof FullHttpRequest) {
                return (FullHttpRequest)NettyHttpRequest.this.nettyRequest;
            }
            return new DefaultFullHttpRequest(nr.protocolVersion(), nr.method(), nr.uri(), Unpooled.EMPTY_BUFFER, nr.headers(), EmptyHttpHeaders.INSTANCE);
        }

        @Override
        @NonNull
        public StreamedHttpRequest toStreamHttpRequest() {
            if (this.isStream()) {
                return (StreamedHttpRequest)NettyHttpRequest.this.nettyRequest;
            }
            FullHttpRequest fullHttpRequest = this.toFullHttpRequest();
            DefaultStreamedHttpRequest request = new DefaultStreamedHttpRequest(fullHttpRequest.protocolVersion(), fullHttpRequest.method(), fullHttpRequest.uri(), true, Publishers.just(new DefaultLastHttpContent(fullHttpRequest.content())));
            request.headers().setAll(fullHttpRequest.headers());
            return request;
        }

        @Override
        @NonNull
        public io.netty.handler.codec.http.HttpRequest toHttpRequest() {
            if (this.isStream()) {
                return this.toStreamHttpRequest();
            }
            return this.toFullHttpRequest();
        }

        @Override
        public boolean isStream() {
            return NettyHttpRequest.this.nettyRequest instanceof StreamedHttpRequest;
        }

        @Override
        public MutableHttpRequest<T> mutate() {
            return new NettyMutableHttpRequest();
        }
    }
}

