/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.server.RequestLifecycle;
import io.micronaut.http.server.netty.FormDataHttpContentProcessor;
import io.micronaut.http.server.netty.FormRouteCompleter;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.body.ByteBody;
import io.micronaut.http.server.netty.types.files.NettyStreamedFileCustomizableResponseType;
import io.micronaut.http.server.netty.types.files.NettySystemFileCustomizableResponseType;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.web.router.RouteMatch;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class NettyRequestLifecycle
extends RequestLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(NettyRequestLifecycle.class);
    private final RoutingInBoundHandler rib;
    private final ChannelHandlerContext ctx;
    private final NettyHttpRequest<?> nettyRequest;

    NettyRequestLifecycle(RoutingInBoundHandler rib, ChannelHandlerContext ctx, NettyHttpRequest<?> request) {
        super(rib.routeExecutor, request);
        this.rib = rib;
        this.ctx = ctx;
        this.nettyRequest = request;
        this.multipartEnabled(rib.multipartEnabled);
    }

    void handleNormal() {
        ExecutionFlow<MutableHttpResponse<?>> result;
        DecoderResult decoderResult;
        this.ctx.channel().config().setAutoRead(false);
        if (LOG.isDebugEnabled()) {
            HttpMethod httpMethod = this.request().getMethod();
            ServerRequestContext.set(this.request());
            LOG.debug("Request {} {}", (Object)httpMethod, (Object)this.request().getUri());
        }
        if ((decoderResult = this.nettyRequest.getNativeRequest().decoderResult()).isFailure()) {
            Throwable cause = decoderResult.cause();
            HttpStatus status = cause instanceof TooLongFrameException ? HttpStatus.REQUEST_ENTITY_TOO_LARGE : HttpStatus.BAD_REQUEST;
            result = this.onStatusError(HttpResponse.status(status), status.getReason());
        } else {
            result = this.normalFlow();
        }
        result.onComplete((response, throwable) -> this.rib.writeResponse(this.ctx, this.nettyRequest, (MutableHttpResponse<?>)response, (Throwable)throwable));
    }

    @Override
    @Nullable
    protected FileCustomizableResponseType findFile() {
        Optional<URL> optionalUrl = this.rib.staticResourceResolver.resolve(this.request().getUri().getPath());
        if (optionalUrl.isPresent()) {
            try {
                File file;
                URL url = optionalUrl.get();
                if (url.getProtocol().equals("file") && (file = Paths.get(url.toURI()).toFile()).exists() && !file.isDirectory() && file.canRead()) {
                    return new NettySystemFileCustomizableResponseType(file);
                }
                return new NettyStreamedFileCustomizableResponseType(url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected ExecutionFlow<RouteMatch<?>> fulfillArguments(RouteMatch<?> routeMatch) {
        DecoderResult decoderResult = this.nettyRequest.getNativeRequest().decoderResult();
        if (decoderResult.isFailure()) {
            return ExecutionFlow.error(decoderResult.cause());
        }
        return super.fulfillArguments(routeMatch).flatMap(this::waitForBody);
    }

    private ExecutionFlow<RouteMatch<?>> waitForBody(RouteMatch<?> routeMatch) {
        if (this.nettyRequest.rootBody().next() != null) {
            this.ctx.read();
            return ExecutionFlow.just(routeMatch);
        }
        HttpContentProcessor processor = this.rib.httpContentProcessorResolver.resolve(this.nettyRequest, routeMatch);
        ByteBody rootBody = this.nettyRequest.rootBody();
        if (processor instanceof FormDataHttpContentProcessor && this.nettyRequest.isFormOrMultipartData()) {
            FormRouteCompleter frc = this.nettyRequest.formRouteCompleter();
            try {
                rootBody.processMulti(processor).handleForm(frc);
            }
            catch (Throwable e) {
                return ExecutionFlow.error(e);
            }
            return frc.execute;
        }
        if (this.needsBody(routeMatch)) {
            return rootBody.buffer(this.nettyRequest.getChannelHandlerContext().alloc()).map(ibb -> {
                try {
                    ibb.processMulti(processor);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return routeMatch;
            });
        }
        this.ctx.read();
        return ExecutionFlow.just(routeMatch);
    }

    void handleException(Throwable cause) {
        this.onError(cause).onComplete((response, throwable) -> this.rib.writeResponse(this.ctx, this.nettyRequest, (MutableHttpResponse<?>)response, (Throwable)throwable));
    }

    private boolean needsBody(RouteMatch<?> routeMatch) {
        return routeMatch.getRouteInfo().needsRequestBody() || !routeMatch.isFulfilled();
    }
}

