/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.Writable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpMessage;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.stream.JsonSubscriber;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.server.RouteExecutor;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.http.server.netty.DelegateStreamedHttpResponse;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.NettyRequestLifecycle;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandler;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import io.micronaut.runtime.http.codec.TextPlainCodec;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.resource.StaticResourceResolver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Internal
@ChannelHandler.Sharable
final class RoutingInBoundHandler
extends SimpleChannelInboundHandler<HttpRequest<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingInBoundHandler.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection (?:reset|closed|abort|broken)|broken pipe).*$", 2);
    final StaticResourceResolver staticResourceResolver;
    final NettyHttpServerConfiguration serverConfiguration;
    final HttpContentProcessorResolver httpContentProcessorResolver;
    final RequestArgumentSatisfier requestArgumentSatisfier;
    final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    final NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry;
    final Supplier<ExecutorService> ioExecutorSupplier;
    final boolean multipartEnabled;
    ExecutorService ioExecutor;
    final ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher;
    final RouteExecutor routeExecutor;
    final ConversionService conversionService;

    RoutingInBoundHandler(NettyHttpServerConfiguration serverConfiguration, NettyCustomizableResponseTypeHandlerRegistry customizableResponseTypeHandlerRegistry, NettyEmbeddedServices embeddedServerContext, Supplier<ExecutorService> ioExecutor, HttpContentProcessorResolver httpContentProcessorResolver, ApplicationEventPublisher<HttpRequestTerminatedEvent> terminateEventPublisher, ConversionService conversionService) {
        this.mediaTypeCodecRegistry = embeddedServerContext.getMediaTypeCodecRegistry();
        this.customizableResponseTypeHandlerRegistry = customizableResponseTypeHandlerRegistry;
        this.staticResourceResolver = embeddedServerContext.getStaticResourceResolver();
        this.ioExecutorSupplier = ioExecutor;
        this.requestArgumentSatisfier = embeddedServerContext.getRequestArgumentSatisfier();
        this.serverConfiguration = serverConfiguration;
        this.httpContentProcessorResolver = httpContentProcessorResolver;
        this.terminateEventPublisher = terminateEventPublisher;
        Optional<Boolean> isMultiPartEnabled = serverConfiguration.getMultipart().getEnabled();
        this.multipartEnabled = isMultiPartEnabled.isEmpty() || isMultiPartEnabled.get() != false;
        this.routeExecutor = embeddedServerContext.getRouteExecutor();
        this.conversionService = conversionService;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.cleanupIfNecessary(ctx);
    }

    @Override
    public void channelInactive(@NonNull ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (ctx.channel().isWritable()) {
            ctx.flush();
        }
        this.cleanupIfNecessary(ctx);
    }

    private void cleanupIfNecessary(ChannelHandlerContext ctx) {
        NettyHttpRequest.remove(ctx);
    }

    private void cleanupRequest(ChannelHandlerContext ctx, NettyHttpRequest<?> request) {
        try {
            request.release();
        }
        finally {
            if (!this.terminateEventPublisher.isEmpty()) {
                ctx.executor().execute(() -> {
                    block2: {
                        try {
                            this.terminateEventPublisher.publishEvent(new HttpRequestTerminatedEvent(request));
                        }
                        catch (Exception e) {
                            if (!LOG.isErrorEnabled()) break block2;
                            LOG.error("Error publishing request terminated event: " + e.getMessage(), e);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            IdleStateEvent idleStateEvent;
            IdleState state;
            if (evt instanceof IdleStateEvent && (state = (idleStateEvent = (IdleStateEvent)evt).state()) == IdleState.ALL_IDLE) {
                ctx.close();
            }
        }
        finally {
            super.userEventTriggered(ctx, evt);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.isIgnorable(cause)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Swallowed an IOException caused by client connectivity: " + cause.getMessage(), cause);
            }
            return;
        }
        NettyHttpRequest nettyHttpRequest = NettyHttpRequest.remove(ctx);
        if (nettyHttpRequest == null) {
            if (cause instanceof SSLException || cause.getCause() instanceof SSLException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
                }
            } else if (LOG.isErrorEnabled()) {
                LOG.error("Micronaut Server Error - No request state present. Cause: " + cause.getMessage(), cause);
            }
            ctx.writeAndFlush(new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
            return;
        }
        new NettyRequestLifecycle(this, ctx, nettyHttpRequest).handleException(cause);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest<?> httpRequest) {
        new NettyRequestLifecycle(this, ctx, (NettyHttpRequest)httpRequest).handleNormal();
    }

    void writeResponse(ChannelHandlerContext ctx, NettyHttpRequest<?> nettyHttpRequest, MutableHttpResponse<?> response, Throwable throwable) {
        if (throwable != null) {
            response = this.routeExecutor.createDefaultErrorResponse(nettyHttpRequest, throwable);
        }
        if (response == null) {
            ctx.read();
        } else {
            try {
                this.encodeHttpResponse(ctx, nettyHttpRequest, response, null, response.body());
            }
            catch (Throwable e) {
                response = this.routeExecutor.createDefaultErrorResponse(nettyHttpRequest, e);
                this.encodeHttpResponse(ctx, nettyHttpRequest, response, null, response.body());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getIoExecutor() {
        ExecutorService executor = this.ioExecutor;
        if (executor == null) {
            RoutingInBoundHandler routingInBoundHandler = this;
            synchronized (routingInBoundHandler) {
                executor = this.ioExecutor;
                if (executor == null) {
                    this.ioExecutor = executor = this.ioExecutorSupplier.get();
                }
            }
        }
        return executor;
    }

    private void encodeHttpResponse(ChannelHandlerContext context, NettyHttpRequest<?> nettyRequest, MutableHttpResponse<?> response, @Nullable Argument<Object> bodyType, Object body) {
        boolean isNotHead;
        boolean bl = isNotHead = nettyRequest.getMethod() != HttpMethod.HEAD;
        if (isNotHead) {
            if (body instanceof Writable) {
                this.getIoExecutor().execute(() -> {
                    ByteBuf byteBuf = context.alloc().ioBuffer(128);
                    ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
                    try {
                        Writable writable = (Writable)body;
                        writable.writeTo(outputStream, nettyRequest.getCharacterEncoding());
                        response.body(byteBuf);
                        if (response.getContentType().isEmpty()) {
                            response.getAttribute(HttpAttributes.ROUTE_INFO, RouteInfo.class).ifPresent(routeInfo -> response.contentType(this.routeExecutor.resolveDefaultResponseContentType(nettyRequest, (RouteInfo<?>)routeInfo)));
                        }
                        this.writeFinalNettyResponse(response, nettyRequest, context);
                    }
                    catch (IOException e) {
                        MutableHttpResponse<?> errorResponse = this.routeExecutor.createDefaultErrorResponse(nettyRequest, e);
                        this.writeFinalNettyResponse(errorResponse, nettyRequest, context);
                    }
                });
            } else if (body instanceof Publisher) {
                response.body((Object)null);
                if (this.serverConfiguration.getServerType() == NettyHttpServerConfiguration.HttpServerType.FULL_CONTENT) {
                    Flux.from(this.mapToHttpContent(nettyRequest, response, body, context)).collectList().subscribe(contents -> {
                        if (contents.size() == 0) {
                            this.setResponseBody(response, Unpooled.EMPTY_BUFFER);
                        } else if (contents.size() == 1) {
                            this.setResponseBody(response, ((HttpContent)contents.get(0)).content().retain());
                        } else {
                            CompositeByteBuf composite = context.alloc().compositeBuffer();
                            for (HttpContent c : contents) {
                                composite.addComponent(true, c.content().retain());
                            }
                            this.setResponseBody(response, composite);
                        }
                        for (HttpContent content : contents) {
                            content.release();
                        }
                        this.writeFinalNettyResponse(response, nettyRequest, context);
                    }, error -> {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error occurred writing publisher response: " + error.getMessage(), (Throwable)error);
                        }
                        HttpResponseStatus responseStatus = error instanceof HttpStatusException ? HttpResponseStatus.valueOf(((HttpStatusException)error).getStatus().getCode(), error.getMessage()) : HttpResponseStatus.INTERNAL_SERVER_ERROR;
                        context.writeAndFlush(new DefaultHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, responseStatus)).addListener(ChannelFutureListener.CLOSE);
                    });
                } else {
                    DelegateStreamedHttpResponse streamedResponse = new DelegateStreamedHttpResponse(this.toNettyResponse(response), this.mapToHttpContent(nettyRequest, response, body, context));
                    context.writeAndFlush(streamedResponse);
                    context.read();
                }
            } else {
                this.encodeResponseBody(context, nettyRequest, response, bodyType, body);
                this.writeFinalNettyResponse(response, nettyRequest, context);
            }
        } else {
            response.body((Object)null);
            this.writeFinalNettyResponse(response, nettyRequest, context);
        }
    }

    private Flux<HttpContent> mapToHttpContent(NettyHttpRequest<?> request, MutableHttpResponse<?> response, Object body, ChannelHandlerContext context) {
        RouteInfo routeInfo = response.getAttribute(HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
        boolean hasRouteInfo = routeInfo != null;
        MediaType mediaType = response.getContentType().orElse(null);
        if (mediaType == null && hasRouteInfo) {
            mediaType = this.routeExecutor.resolveDefaultResponseContentType(request, routeInfo);
        }
        boolean isJson = mediaType != null && mediaType.getExtension().equals("json") && this.isJsonFormattable(hasRouteInfo ? routeInfo.getBodyType() : null);
        NettyByteBufferFactory byteBufferFactory = new NettyByteBufferFactory(context.alloc());
        Flux<Object> bodyPublisher = Flux.from(Publishers.convertPublisher(this.conversionService, body, Publisher.class));
        MediaType finalMediaType = mediaType;
        Flux<HttpContent> httpContentPublisher = bodyPublisher.map(message -> {
            HttpContent httpContent;
            if (message instanceof ByteBuf) {
                ByteBuf bb = (ByteBuf)message;
                httpContent = new DefaultHttpContent(bb);
            } else if (message instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)message;
                Object nativeBuffer = byteBuffer.asNativeBuffer();
                if (nativeBuffer instanceof ByteBuf) {
                    ByteBuf bb = (ByteBuf)nativeBuffer;
                    httpContent = new DefaultHttpContent(bb);
                } else {
                    httpContent = new DefaultHttpContent(Unpooled.copiedBuffer(byteBuffer.asNioBuffer()));
                }
            } else if (message instanceof byte[]) {
                byte[] bytes = (byte[])message;
                httpContent = new DefaultHttpContent(Unpooled.copiedBuffer(bytes));
            } else if (message instanceof HttpContent) {
                HttpContent hc = (HttpContent)message;
                httpContent = hc;
            } else {
                Argument<?> bodyType;
                MediaTypeCodec codec = this.mediaTypeCodecRegistry.findCodec(finalMediaType, message.getClass()).orElse(new TextPlainCodec(this.serverConfiguration.getDefaultCharset(), this.conversionService));
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Encoding emitted response object [{}] using codec: {}", message, (Object)codec);
                }
                ByteBuffer<ByteBuf> encoded = hasRouteInfo ? ((bodyType = routeInfo.getBodyType()).isInstance(message) ? codec.encode(bodyType, message, byteBufferFactory) : codec.encode(message, byteBufferFactory)) : codec.encode(message, byteBufferFactory);
                httpContent = new DefaultHttpContent(encoded.asNativeBuffer());
            }
            return httpContent;
        });
        if (isJson) {
            httpContentPublisher = JsonSubscriber.lift(httpContentPublisher);
        }
        httpContentPublisher = httpContentPublisher.contextWrite(reactorContext -> reactorContext.put("micronaut.http.server.request", request)).doOnNext(httpContent -> context.read()).doAfterTerminate(() -> this.cleanupRequest(context, request));
        return httpContentPublisher;
    }

    private boolean isJsonFormattable(Argument<?> argument) {
        if (argument == null) {
            return false;
        }
        Class javaType = argument.getType();
        if (Publishers.isConvertibleToPublisher(javaType)) {
            javaType = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT).getType();
        }
        return javaType != byte[].class && !ByteBuffer.class.isAssignableFrom(javaType) && !ByteBuf.class.isAssignableFrom(javaType);
    }

    private void encodeResponseBody(ChannelHandlerContext context, HttpRequest<?> request, MutableHttpResponse<?> message, @Nullable Argument<Object> bodyType, Object body) {
        if (body == null) {
            return;
        }
        Optional<NettyCustomizableResponseTypeHandler> typeHandler = this.customizableResponseTypeHandlerRegistry.findTypeHandler(body.getClass());
        if (typeHandler.isPresent()) {
            NettyCustomizableResponseTypeHandler th = typeHandler.get();
            this.setBodyContent(message, new NettyCustomizableResponseTypeHandlerInvoker(th, body));
        } else {
            MediaType mediaType = message.getContentType().orElse(null);
            if (mediaType == null) {
                mediaType = message.getAttribute(HttpAttributes.ROUTE_INFO, RouteInfo.class).map(routeInfo -> this.routeExecutor.resolveDefaultResponseContentType(request, (RouteInfo<?>)routeInfo)).orElse(MediaType.APPLICATION_JSON_TYPE);
                message.contentType(mediaType);
            }
            if (body instanceof CharSequence) {
                ByteBuf byteBuf = Unpooled.wrappedBuffer(body.toString().getBytes(message.getCharacterEncoding()));
                this.setResponseBody(message, byteBuf);
            } else if (body instanceof byte[]) {
                byte[] bytes = (byte[])body;
                ByteBuf byteBuf = Unpooled.wrappedBuffer(bytes);
                this.setResponseBody(message, byteBuf);
            } else if (body instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)body;
                Object nativeBuffer = byteBuffer.asNativeBuffer();
                if (nativeBuffer instanceof ByteBuf) {
                    ByteBuf bb = (ByteBuf)nativeBuffer;
                    this.setResponseBody(message, bb);
                } else if (nativeBuffer instanceof java.nio.ByteBuffer) {
                    java.nio.ByteBuffer nbb = (java.nio.ByteBuffer)nativeBuffer;
                    ByteBuf byteBuf = Unpooled.wrappedBuffer(nbb);
                    this.setResponseBody(message, byteBuf);
                }
            } else if (body instanceof ByteBuf) {
                ByteBuf bb = (ByteBuf)body;
                this.setResponseBody(message, bb);
            } else {
                Optional<MediaTypeCodec> registeredCodec = this.mediaTypeCodecRegistry.findCodec(mediaType, body.getClass());
                if (registeredCodec.isPresent()) {
                    MediaTypeCodec codec = registeredCodec.get();
                    this.encodeBodyWithCodec(message, bodyType, body, codec, context, request);
                } else {
                    TextPlainCodec defaultCodec = new TextPlainCodec(this.serverConfiguration.getDefaultCharset(), this.conversionService);
                    this.encodeBodyWithCodec(message, bodyType, body, defaultCodec, context, request);
                }
            }
        }
    }

    private void writeFinalNettyResponse(MutableHttpResponse<?> message, final HttpRequest<?> request, final ChannelHandlerContext context) {
        int httpStatus = message.code();
        HttpVersion httpVersion = request.getHttpVersion();
        boolean isHttp2 = httpVersion == HttpVersion.HTTP_2_0;
        boolean decodeError = request instanceof NettyHttpRequest && ((NettyHttpRequest)request).getNativeRequest().decoderResult().isFailure();
        final GenericFutureListener<Future<? super Void>> requestCompletor = future -> {
            try {
                Throwable throwable;
                if (!future.isSuccess() && !this.isIgnorable(throwable = future.cause())) {
                    Http2Exception.StreamException se;
                    if (throwable instanceof Http2Exception.StreamException && (se = (Http2Exception.StreamException)throwable).error() == Http2Error.STREAM_CLOSED) {
                        return;
                    }
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Error writing final response: " + throwable.getMessage(), throwable);
                    }
                }
            }
            finally {
                if (request instanceof NettyHttpRequest) {
                    this.cleanupRequest(context, (NettyHttpRequest)request);
                }
                context.read();
            }
        };
        Object body = message.body();
        if (body instanceof NettyCustomizableResponseTypeHandlerInvoker) {
            if (!isHttp2 && !message.getHeaders().contains("Connection")) {
                if (!decodeError && (httpStatus < 500 || this.serverConfiguration.isKeepAliveOnServerError())) {
                    message.getHeaders().set("Connection", HttpHeaderValues.KEEP_ALIVE);
                } else {
                    message.getHeaders().set("Connection", HttpHeaderValues.CLOSE);
                }
            }
            NettyCustomizableResponseTypeHandlerInvoker handler = (NettyCustomizableResponseTypeHandlerInvoker)body;
            message.body((Object)null);
            handler.invoke(request, message, context).addListener((GenericFutureListener<? extends Future<? super Void>>)requestCompletor);
        } else {
            StreamedHttpRequest streamedHttpRequest;
            NettyHttpRequest nettyHttpRequest;
            io.netty.handler.codec.http.HttpRequest nativeRequest;
            final io.netty.handler.codec.http.HttpResponse nettyResponse = NettyHttpResponseBuilder.toHttpResponse(message);
            io.netty.handler.codec.http.HttpHeaders nettyHeaders = nettyResponse.headers();
            if (!isHttp2 && !nettyHeaders.contains(HttpHeaderNames.CONNECTION)) {
                boolean expectKeepAlive;
                boolean bl = expectKeepAlive = nettyResponse.protocolVersion().isKeepAliveDefault() || request.getHeaders().isKeepAlive();
                if (!decodeError && expectKeepAlive && (httpStatus < 500 || this.serverConfiguration.isKeepAliveOnServerError())) {
                    nettyHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                } else {
                    nettyHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                }
            }
            if (!nettyHeaders.contains(HttpHeaderNames.CONTENT_LENGTH) && !nettyHeaders.contains(HttpHeaderNames.TRANSFER_ENCODING)) {
                nettyHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
            if ((nativeRequest = (nettyHttpRequest = (NettyHttpRequest)request).getNativeRequest()) instanceof StreamedHttpRequest && !(streamedHttpRequest = (StreamedHttpRequest)nativeRequest).isConsumed()) {
                streamedHttpRequest.subscribe(new Subscriber<HttpContent>(){
                    private Subscription streamSub;

                    @Override
                    public void onSubscribe(Subscription s) {
                        this.streamSub = s;
                        s.request(1L);
                    }

                    @Override
                    public void onNext(HttpContent httpContent) {
                        httpContent.release();
                        this.streamSub.request(1L);
                    }

                    @Override
                    public void onError(Throwable t) {
                        RoutingInBoundHandler.this.syncWriteAndFlushNettyResponse(context, request, nettyResponse, requestCompletor);
                    }

                    @Override
                    public void onComplete() {
                        RoutingInBoundHandler.this.syncWriteAndFlushNettyResponse(context, request, nettyResponse, requestCompletor);
                    }
                });
            } else {
                this.syncWriteAndFlushNettyResponse(context, request, nettyResponse, requestCompletor);
            }
        }
    }

    private void syncWriteAndFlushNettyResponse(ChannelHandlerContext context, HttpRequest<?> request, io.netty.handler.codec.http.HttpResponse nettyResponse, GenericFutureListener<Future<? super Void>> requestCompletor) {
        context.writeAndFlush(nettyResponse).addListener((GenericFutureListener<? extends Future<? super Void>>)requestCompletor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response {} - {} {}", nettyResponse.status().code(), request.getMethodName(), request.getUri());
        }
    }

    @NonNull
    private io.netty.handler.codec.http.HttpResponse toNettyResponse(HttpResponse<?> message) {
        if (message instanceof NettyHttpResponseBuilder) {
            NettyHttpResponseBuilder builder = (NettyHttpResponseBuilder)((Object)message);
            return builder.toHttpResponse();
        }
        return this.createNettyResponse(message).toHttpResponse();
    }

    @NonNull
    private NettyMutableHttpResponse<?> createNettyResponse(HttpResponse<?> message) {
        Object body = message.body();
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(this.serverConfiguration.isValidateHeaders());
        message.getHeaders().forEach(nettyHeaders::set);
        return new NettyMutableHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(message.code(), message.reason()), body instanceof ByteBuf ? body : null, this.conversionService);
    }

    private MutableHttpResponse<?> encodeBodyWithCodec(MutableHttpResponse<?> response, @Nullable Argument<Object> bodyType, Object body, MediaTypeCodec codec, ChannelHandlerContext context, HttpRequest<?> request) {
        try {
            ByteBuf byteBuf = this.encodeBodyAsByteBuf(bodyType, body, codec, context, request);
            this.setResponseBody(response, byteBuf);
            return response;
        }
        catch (LinkageError e) {
            throw new InternalServerException("Fatal error encoding bytebuf: " + e.getMessage(), e);
        }
    }

    private void setResponseBody(MutableHttpResponse<?> response, ByteBuf byteBuf) {
        int len = byteBuf.readableBytes();
        HttpHeaders headers = response.getHeaders();
        headers.set(HttpHeaderNames.CONTENT_LENGTH, String.valueOf(len));
        this.setBodyContent(response, byteBuf);
    }

    private MutableHttpResponse<?> setBodyContent(MutableHttpResponse<?> response, Object bodyContent) {
        MutableHttpMessage res = response.body(bodyContent);
        return res;
    }

    private ByteBuf encodeBodyAsByteBuf(@Nullable Argument<Object> bodyType, Object body, MediaTypeCodec codec, ChannelHandlerContext context, HttpRequest<?> request) {
        ByteBuf byteBuf;
        if (body instanceof ByteBuf) {
            ByteBuf bb;
            byteBuf = bb = (ByteBuf)body;
        } else if (body instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)body;
            Object nativeBuffer = byteBuffer.asNativeBuffer();
            byteBuf = nativeBuffer instanceof ByteBuf ? (ByteBuf)nativeBuffer : Unpooled.wrappedBuffer(byteBuffer.asNioBuffer());
        } else if (body instanceof byte[]) {
            byte[] bytes = (byte[])body;
            byteBuf = Unpooled.wrappedBuffer(bytes);
        } else if (body instanceof Writable) {
            byteBuf = context.alloc().ioBuffer(128);
            ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);
            Writable writable = (Writable)body;
            try {
                writable.writeTo(outputStream, request.getCharacterEncoding());
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage());
                }
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Encoding emitted response object [{}] using codec: {}", body, (Object)codec);
            }
            ByteBuffer<ByteBuf> wrapped = bodyType != null && bodyType.isInstance(body) ? codec.encode(bodyType, body, new NettyByteBufferFactory(context.alloc())) : codec.encode(body, new NettyByteBufferFactory(context.alloc()));
            byteBuf = wrapped.asNativeBuffer().retain();
            if (wrapped instanceof ReferenceCounted) {
                ((ReferenceCounted)((Object)wrapped)).release();
            }
        }
        return byteBuf;
    }

    boolean isIgnorable(Throwable cause) {
        if (cause instanceof ClosedChannelException || cause.getCause() instanceof ClosedChannelException) {
            return true;
        }
        String message = cause.getMessage();
        return cause instanceof IOException && message != null && IGNORABLE_ERROR_MESSAGE.matcher(message).matches();
    }

    private static class NettyCustomizableResponseTypeHandlerInvoker {
        final NettyCustomizableResponseTypeHandler handler;
        final Object body;

        NettyCustomizableResponseTypeHandlerInvoker(NettyCustomizableResponseTypeHandler handler, Object body) {
            this.handler = handler;
            this.body = body;
        }

        ChannelFuture invoke(HttpRequest<?> request, MutableHttpResponse response, ChannelHandlerContext channelHandlerContext) {
            return this.handler.handle(this.body, request, response, channelHandlerContext);
        }
    }
}

