/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.binders;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.binders.CompletableFutureBodyBinder;
import io.micronaut.http.server.netty.binders.CompletedFileUploadBinder;
import io.micronaut.http.server.netty.binders.InputStreamBodyBinder;
import io.micronaut.http.server.netty.binders.PartUploadAnnotationBinder;
import io.micronaut.http.server.netty.binders.PublisherPartUploadBinder;
import io.micronaut.http.server.netty.binders.StreamingFileUploadBinder;
import io.micronaut.http.server.netty.multipart.MultipartBodyArgumentBinder;
import io.micronaut.http.server.netty.multipart.NettyStreamingFileUpload;
import jakarta.inject.Named;
import java.util.concurrent.ExecutorService;

@Prototype
@Internal
class NettyBinderRegistrar
implements BeanCreatedEventListener<RequestBinderRegistry> {
    private final ConversionService conversionService;
    private final HttpContentProcessorResolver httpContentProcessorResolver;
    private final BeanLocator beanLocator;
    private final BeanProvider<HttpServerConfiguration> httpServerConfiguration;
    private final BeanProvider<ExecutorService> executorService;

    NettyBinderRegistrar(ConversionService conversionService, HttpContentProcessorResolver httpContentProcessorResolver, BeanLocator beanLocator, BeanProvider<HttpServerConfiguration> httpServerConfiguration, @Named(value="blocking") BeanProvider<ExecutorService> executorService) {
        this.conversionService = conversionService;
        this.httpContentProcessorResolver = httpContentProcessorResolver;
        this.beanLocator = beanLocator;
        this.httpServerConfiguration = httpServerConfiguration;
        this.executorService = executorService;
    }

    @Override
    public RequestBinderRegistry onCreated(BeanCreatedEvent<RequestBinderRegistry> event) {
        RequestBinderRegistry registry = (RequestBinderRegistry)event.getBean();
        registry.addArgumentBinder(new CompletableFutureBodyBinder(this.httpContentProcessorResolver, this.conversionService, this.httpServerConfiguration));
        registry.addArgumentBinder(new MultipartBodyArgumentBinder(this.beanLocator, this.httpServerConfiguration));
        registry.addArgumentBinder(new InputStreamBodyBinder(this.httpContentProcessorResolver));
        NettyStreamingFileUpload.Factory fileUploadFactory = new NettyStreamingFileUpload.Factory(this.httpServerConfiguration.get().getMultipart(), this.executorService.get());
        registry.addArgumentBinder(new StreamingFileUploadBinder(this.conversionService, fileUploadFactory));
        CompletedFileUploadBinder completedFileUploadBinder = new CompletedFileUploadBinder(this.conversionService);
        registry.addArgumentBinder(completedFileUploadBinder);
        PublisherPartUploadBinder publisherPartUploadBinder = new PublisherPartUploadBinder(this.conversionService, fileUploadFactory);
        registry.addArgumentBinder(publisherPartUploadBinder);
        PartUploadAnnotationBinder<Object> partUploadAnnotationBinder = new PartUploadAnnotationBinder<Object>(this.conversionService, completedFileUploadBinder, publisherPartUploadBinder);
        registry.addArgumentBinder(partUploadAnnotationBinder);
        registry.addUnmatchedRequestArgumentBinder(partUploadAnnotationBinder);
        return registry;
    }
}

